/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.guice.annotations.Global;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.task.Task;
import io.druid.testing.IntegrationTestingConfig;
import io.druid.testing.clients.TaskResponseObject;
import io.druid.testing.utils.RetryUtil;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class OverlordResourceTestClient {
    private static final Logger LOG = new Logger(OverlordResourceTestClient.class);
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String indexer;
    private final StatusResponseHandler responseHandler;

    @Inject
    OverlordResourceTestClient(ObjectMapper jsonMapper, @Global HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.indexer = config.getIndexerHost();
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
    }

    private String getIndexerURL() {
        return String.format("http://%s/druid/indexer/v1/", this.indexer);
    }

    public String submitTask(Task task) {
        try {
            return this.submitTask(this.jsonMapper.writeValueAsString((Object)task));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String submitTask(String task) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "task")).setContent("application/json", task.getBytes()), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while submitting task to indexer response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String taskID = (String)responseData.get("task");
            LOG.info("Submitted task with TaskID[%s]", new Object[]{taskID});
            return taskID;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public TaskStatus.Status getTaskStatus(String taskID) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, String.format("%stask/%s/status", this.getIndexerURL(), URLEncoder.encode(taskID, "UTF-8")));
            LOG.info("Index status response" + response.getContent(), new Object[0]);
            Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String status = (String)((Map)responseData.get("status")).get("status");
            return TaskStatus.Status.valueOf((String)status);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<TaskResponseObject> getRunningTasks() {
        return this.getTasks("runningTasks");
    }

    public List<TaskResponseObject> getWaitingTasks() {
        return this.getTasks("waitingTasks");
    }

    public List<TaskResponseObject> getPendingTasks() {
        return this.getTasks("pendingTasks");
    }

    private List<TaskResponseObject> getTasks(String identifier) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, String.format("%s%s", this.getIndexerURL(), identifier));
            LOG.info("Tasks %s response %s", new Object[]{identifier, response.getContent()});
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<TaskResponseObject>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Map<String, String> shutDownTask(String taskID) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.POST, String.format("%stask/%s/shutdown", this.getIndexerURL(), URLEncoder.encode(taskID, "UTF-8")));
            LOG.info("Shutdown Task %s response %s", new Object[]{taskID, response.getContent()});
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void waitUntilTaskCompletes(String taskID) {
        this.waitUntilTaskCompletes(taskID, 60000, 10);
    }

    public void waitUntilTaskCompletes(final String taskID, int millisEach, int numTimes) {
        RetryUtil.retryUntil(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TaskStatus.Status status = OverlordResourceTestClient.this.getTaskStatus(taskID);
                if (status == TaskStatus.Status.FAILED) {
                    throw new ISE("Indexer task FAILED", new Object[0]);
                }
                return status == TaskStatus.Status.SUCCESS;
            }
        }, true, millisEach, numTimes, taskID);
    }

    public String submitSupervisor(String spec) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getIndexerURL() + "supervisor")).setContent("application/json", spec.getBytes()), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while submitting supervisor to overlord, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Map responseData = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String id = (String)responseData.get("id");
            LOG.info("Submitted supervisor with id[%s]", new Object[]{id});
            return id;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void shutdownSupervisor(String id) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(String.format("%ssupervisor/%s/shutdown", this.getIndexerURL(), id))), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while shutting down supervisor, response [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            LOG.info("Shutdown supervisor with id[%s]", new Object[]{id});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private StatusResponseHolder makeRequest(HttpMethod method, String url) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(method, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while making request to indexer [%s %s]", new Object[]{response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Exception while sending request", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

