/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.guice.annotations.Global;
import io.druid.query.Query;
import io.druid.testing.IntegrationTestingConfig;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class QueryResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String router;
    private final StatusResponseHandler responseHandler;

    @Inject
    QueryResourceTestClient(ObjectMapper jsonMapper, @Global HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.router = config.getRouterHost();
        this.responseHandler = new StatusResponseHandler(Charsets.UTF_8);
    }

    private String getBrokerURL() {
        return String.format("http://%s/druid/v2/", this.router);
    }

    public List<Map<String, Object>> query(Query query) {
        return this.query(this.getBrokerURL(), query);
    }

    public List<Map<String, Object>> query(String url, Query query) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)query)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while querying[%s] status[%s] content[%s]", new Object[]{this.getBrokerURL(), response.getStatus(), response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

