/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.utils;

import com.google.common.base.Throwables;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class RetryUtil {
    private static final Logger LOG = new Logger(RetryUtil.class);
    public static int DEFAULT_RETRY_COUNT = 10;
    public static long DEFAULT_RETRY_SLEEP = TimeUnit.SECONDS.toMillis(30L);

    public static void retryUntilTrue(Callable<Boolean> callable, String task) {
        RetryUtil.retryUntil(callable, true, DEFAULT_RETRY_SLEEP, DEFAULT_RETRY_COUNT, task);
    }

    public static void retryUntilFalse(Callable<Boolean> callable, String task) {
        RetryUtil.retryUntil(callable, false, DEFAULT_RETRY_SLEEP, DEFAULT_RETRY_COUNT, task);
    }

    public static void retryUntil(Callable<Boolean> callable, boolean expectedValue, long delayInMillis, int retryCount, String taskMessage) {
        try {
            int currentTry = 0;
            while (callable.call() != expectedValue) {
                if (currentTry > retryCount) {
                    throw new ISE("Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage});
                }
                LOG.info("Attempt[%d]: Task %s still not complete. Next retry in %d ms", new Object[]{currentTry, taskMessage, delayInMillis});
                Thread.sleep(delayInMillis);
                ++currentTry;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

