/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.utils;

import com.metamx.common.logger.Logger;
import io.druid.client.selector.Server;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.testing.utils.RetryUtil;
import java.util.concurrent.Callable;

public class ServerDiscoveryUtil {
    private static final Logger LOG = new Logger(ServerDiscoveryUtil.class);

    public static boolean isInstanceReady(ServerDiscoverySelector serviceProvider) {
        try {
            Server instance = serviceProvider.pick();
            if (instance == null) {
                LOG.warn("Unable to find a host", new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Caught exception waiting for host", new Object[0]);
            return false;
        }
        return true;
    }

    public static void waitUntilInstanceReady(final ServerDiscoverySelector serviceProvider, String instanceType) {
        RetryUtil.retryUntilTrue(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ServerDiscoveryUtil.isInstanceReady(serviceProvider);
            }
        }, String.format("Instance %s to get ready", instanceType));
    }
}

