/*
 * Decompiled with CFR 0.152.
 */
package io.druid.testing.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.testing.IntegrationTestingConfig;
import io.druid.testing.clients.QueryResourceTestClient;
import io.druid.testing.utils.QueryResultVerifier;
import io.druid.testing.utils.QueryWithResults;
import java.util.List;
import java.util.Map;

public class TestQueryHelper {
    public static Logger LOG = new Logger(TestQueryHelper.class);
    private final QueryResourceTestClient queryClient;
    private final ObjectMapper jsonMapper;
    private final String broker;

    @Inject
    TestQueryHelper(ObjectMapper jsonMapper, QueryResourceTestClient queryClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.queryClient = queryClient;
        this.broker = config.getBrokerHost();
    }

    public void testQueriesFromFile(String filePath, int timesToRun) throws Exception {
        this.testQueriesFromFile(this.getBrokerURL(), filePath, timesToRun);
    }

    public void testQueriesFromFile(String url, String filePath, int timesToRun) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), (TypeReference)new TypeReference<List<QueryWithResults>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    public void testQueriesFromString(String str, int timesToRun) throws Exception {
        this.testQueriesFromString(this.getBrokerURL(), str, timesToRun);
    }

    public void testQueriesFromString(String url, String str, int timesToRun) throws Exception {
        LOG.info("Starting query tests using\n%s", new Object[]{str});
        List queries = (List)this.jsonMapper.readValue(str, (TypeReference)new TypeReference<List<QueryWithResults>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    private void testQueries(String url, List<QueryWithResults> queries, int timesToRun) throws Exception {
        for (int i = 0; i < timesToRun; ++i) {
            LOG.info("Starting Iteration %d", new Object[]{i});
            boolean failed = false;
            for (QueryWithResults queryWithResult : queries) {
                LOG.info("Running Query %s", new Object[]{queryWithResult.getQuery().getType()});
                List<Map<String, Object>> result = this.queryClient.query(url, queryWithResult.getQuery());
                if (!QueryResultVerifier.compareResults(result, queryWithResult.getExpectedResults())) {
                    LOG.error("Failed while executing query %s \n expectedResults: %s \n actualResults : %s", new Object[]{queryWithResult.getQuery(), this.jsonMapper.writeValueAsString(queryWithResult.getExpectedResults()), this.jsonMapper.writeValueAsString(result)});
                    failed = true;
                    continue;
                }
                LOG.info("Results Verified for Query %s", new Object[]{queryWithResult.getQuery().getType()});
            }
            if (!failed) continue;
            throw new ISE("one or more queries failed", new Object[0]);
        }
    }

    private String getBrokerURL() {
        return String.format("http://%s/druid/v2?pretty", this.broker);
    }
}

