/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.Request;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.StatusResponseHandler;
import com.metamx.http.client.response.StatusResponseHolder;
import io.druid.guice.annotations.Global;
import io.druid.testing.IntegrationTestingConfig;
import io.druid.testing.guice.DruidTestModuleFactory;
import io.druid.testing.utils.RetryUtil;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestRunner;
import org.testng.internal.IConfiguration;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class DruidTestRunnerFactory
implements ITestRunnerFactory {
    private static final Logger LOG = new Logger(DruidTestRunnerFactory.class);

    public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
        IConfiguration configuration = TestNG.getDefault().getConfiguration();
        String outputDirectory = suite.getOutputDirectory();
        IAnnotationFinder annotationFinder = configuration.getAnnotationFinder();
        Boolean skipFailedInvocationCounts = suite.getXmlSuite().skipFailedInvocationCounts();
        return new DruidTestRunner(configuration, suite, test, outputDirectory, annotationFinder, skipFailedInvocationCounts, listeners);
    }

    private static class DruidTestRunner
    extends TestRunner {
        protected DruidTestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
            super(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners);
        }

        public void run() {
            Injector injector = DruidTestModuleFactory.getInjector();
            IntegrationTestingConfig config = (IntegrationTestingConfig)injector.getInstance(IntegrationTestingConfig.class);
            HttpClient client = (HttpClient)injector.getInstance(Key.get(HttpClient.class, Global.class));
            this.waitUntilInstanceReady(client, config.getCoordinatorHost());
            this.waitUntilInstanceReady(client, config.getIndexerHost());
            this.waitUntilInstanceReady(client, config.getBrokerHost());
            String routerHost = config.getRouterHost();
            if (null != routerHost) {
                this.waitUntilInstanceReady(client, config.getRouterHost());
            }
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            try {
                lifecycle.start();
                this.runTests();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                lifecycle.stop();
            }
        }

        private void runTests() {
            super.run();
        }

        public void waitUntilInstanceReady(final HttpClient client, final String host) {
            final StatusResponseHandler handler = new StatusResponseHandler(Charsets.UTF_8);
            RetryUtil.retryUntilTrue(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(String.format("http://%s/status", host))), (HttpResponseHandler)handler).get();
                        System.out.println(response.getStatus() + response.getContent());
                        if (response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                            return true;
                        }
                        return false;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }, "Waiting for instance to be ready: [" + host + "]");
        }
    }
}

