/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.druid.guice.ConfigModule;
import io.druid.guice.DruidGuiceExtensions;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.PropertiesModule;
import io.druid.jackson.JacksonModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GuiceInjectors {
    public static Collection<Module> makeDefaultStartupModules() {
        return ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new JacksonModule(), (Object)new PropertiesModule(Arrays.asList("common.runtime.properties", "runtime.properties")), (Object)new ConfigModule(), (Object)new Module(){

            public void configure(Binder binder) {
                binder.bind(DruidSecondaryModule.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.extensions", ExtensionsConfig.class);
            }
        });
    }

    public static Injector makeStartupInjector() {
        return Guice.createInjector(GuiceInjectors.makeDefaultStartupModules());
    }

    public static Injector makeStartupInjectorWithModules(Iterable<? extends Module> modules) {
        ArrayList theModules = Lists.newArrayList();
        theModules.addAll(GuiceInjectors.makeDefaultStartupModules());
        for (Module module : modules) {
            theModules.add(module);
        }
        return Guice.createInjector((Iterable)theModules);
    }
}

