/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.ISE;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.common.utils.VMUtils;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public class CPUTimeMetricQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> delegate;
    private final Function<Query<T>, ServiceMetricEvent.Builder> builderFn;
    private final ServiceEmitter emitter;
    private final AtomicLong cpuTimeAccumulator;
    private final boolean report;

    private CPUTimeMetricQueryRunner(QueryRunner<T> delegate, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, ServiceEmitter emitter, AtomicLong cpuTimeAccumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            throw new ISE("Cpu time must enabled", new Object[0]);
        }
        this.delegate = delegate;
        this.builderFn = builderFn;
        this.emitter = emitter;
        this.cpuTimeAccumulator = cpuTimeAccumulator == null ? new AtomicLong(0L) : cpuTimeAccumulator;
        this.report = report;
    }

    @Override
    public Sequence<T> run(final Query<T> query, Map<String, Object> responseContext) {
        final Sequence<T> baseSequence = this.delegate.run(query, responseContext);
        return Sequences.withEffect((Sequence)new Sequence<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                long start = VMUtils.getCurrentThreadCpuTime();
                try {
                    Object object = baseSequence.accumulate(initValue, accumulator);
                    return (OutType)object;
                }
                finally {
                    CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                }
            }

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                final Yielder delegateYielder = baseSequence.toYielder(initValue, accumulator);
                return new Yielder<OutType>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public OutType get() {
                        long start = VMUtils.getCurrentThreadCpuTime();
                        try {
                            Object object = delegateYielder.get();
                            return object;
                        }
                        finally {
                            CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Yielder<OutType> next(OutType initValue) {
                        long start = VMUtils.getCurrentThreadCpuTime();
                        try {
                            Yielder yielder = delegateYielder.next(initValue);
                            return yielder;
                        }
                        finally {
                            CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                        }
                    }

                    public boolean isDone() {
                        return delegateYielder.isDone();
                    }

                    public void close() throws IOException {
                        delegateYielder.close();
                    }
                };
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                long cpuTime;
                if (CPUTimeMetricQueryRunner.this.report && (cpuTime = CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get()) > 0L) {
                    ServiceMetricEvent.Builder builder = (ServiceMetricEvent.Builder)Preconditions.checkNotNull((Object)CPUTimeMetricQueryRunner.this.builderFn.apply((Object)query));
                    builder.setDimension("id", Strings.nullToEmpty((String)query.getId()));
                    CPUTimeMetricQueryRunner.this.emitter.emit(builder.build("query/cpu/time", (Number)(CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get() / 1000L)));
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public static <T> QueryRunner<T> safeBuild(QueryRunner<T> delegate, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, ServiceEmitter emitter, AtomicLong accumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            return delegate;
        }
        return new CPUTimeMetricQueryRunner<T>(delegate, builderFn, emitter, accumulator, report);
    }
}

