/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.common.StringUtils;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.DimensionSelector;
import java.nio.ByteBuffer;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String dimension;
    private final ExtractionFn extractionFn;
    private final String outputName;

    @JsonCreator
    public ExtractionDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @Deprecated @JsonProperty(value="dimExtractionFn") ExtractionFn dimExtractionFn) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension must not be null");
        Preconditions.checkArgument((extractionFn != null || dimExtractionFn != null ? 1 : 0) != 0, (Object)"extractionFn must not be null");
        this.dimension = dimension;
        this.extractionFn = extractionFn != null ? extractionFn : dimExtractionFn;
        this.outputName = outputName == null ? dimension : outputName;
    }

    public ExtractionDimensionSpec(String dimension, String outputName, ExtractionFn extractionFn) {
        this(dimension, outputName, extractionFn, null);
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] dimExtractionFnBytes = this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(1 + dimensionBytes.length + dimExtractionFnBytes.length).put((byte)1).put(dimensionBytes).put(dimExtractionFnBytes).array();
    }

    @Override
    public boolean preservesOrdering() {
        return this.extractionFn.preservesOrdering();
    }

    public String toString() {
        return "ExtractionDimensionSpec{dimension='" + this.dimension + '\'' + ", extractionFn=" + this.extractionFn + ", outputName='" + this.outputName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtractionDimensionSpec that = (ExtractionDimensionSpec)o;
        if (this.extractionFn != null ? !this.extractionFn.equals(that.extractionFn) : that.extractionFn != null) {
            return false;
        }
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        return !(this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        return result;
    }
}

