/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.metamx.common.guava.nary.BinaryFn;
import io.druid.granularity.AllGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.TopNResultMerger;
import io.druid.query.topn.TopNResultValue;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.joda.time.DateTime;

public class TopNBinaryFn
implements BinaryFn<Result<TopNResultValue>, Result<TopNResultValue>, Result<TopNResultValue>> {
    private final TopNResultMerger merger;
    private final DimensionSpec dimSpec;
    private final QueryGranularity gran;
    private final String dimension;
    private final TopNMetricSpec topNMetricSpec;
    private final int threshold;
    private final List<AggregatorFactory> aggregations;
    private final List<PostAggregator> postAggregations;
    private final Comparator comparator;

    public TopNBinaryFn(TopNResultMerger merger, QueryGranularity granularity, DimensionSpec dimSpec, TopNMetricSpec topNMetricSpec, int threshold, List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        this.merger = merger;
        this.dimSpec = dimSpec;
        this.gran = granularity;
        this.topNMetricSpec = topNMetricSpec;
        this.threshold = threshold;
        this.aggregations = aggregatorSpecs;
        this.postAggregations = AggregatorUtil.pruneDependentPostAgg(postAggregatorSpecs, topNMetricSpec.getMetricName(dimSpec));
        this.dimension = dimSpec.getOutputName();
        this.comparator = topNMetricSpec.getComparator(aggregatorSpecs, postAggregatorSpecs);
    }

    public Result<TopNResultValue> apply(Result<TopNResultValue> arg1, Result<TopNResultValue> arg2) {
        if (arg1 == null) {
            return this.merger.getResult(arg2, this.comparator);
        }
        if (arg2 == null) {
            return this.merger.getResult(arg1, this.comparator);
        }
        LinkedHashMap<String, DimensionAndMetricValueExtractor> retVals = new LinkedHashMap<String, DimensionAndMetricValueExtractor>();
        TopNResultValue arg1Vals = arg1.getValue();
        TopNResultValue arg2Vals = arg2.getValue();
        for (DimensionAndMetricValueExtractor arg1Val : arg1Vals) {
            retVals.put(arg1Val.getStringDimensionValue(this.dimension), arg1Val);
        }
        for (DimensionAndMetricValueExtractor arg2Val : arg2Vals) {
            String dimensionValue = arg2Val.getStringDimensionValue(this.dimension);
            DimensionAndMetricValueExtractor arg1Val = (DimensionAndMetricValueExtractor)retVals.get(dimensionValue);
            if (arg1Val != null) {
                LinkedHashMap<String, Object> retVal = new LinkedHashMap<String, Object>(this.aggregations.size() + 2);
                retVal.put(this.dimension, dimensionValue);
                for (AggregatorFactory factory : this.aggregations) {
                    String metricName = factory.getName();
                    retVal.put(metricName, factory.combine(arg1Val.getMetric(metricName), arg2Val.getMetric(metricName)));
                }
                for (PostAggregator pf : this.postAggregations) {
                    retVal.put(pf.getName(), pf.compute(retVal));
                }
                retVals.put(dimensionValue, new DimensionAndMetricValueExtractor(retVal));
                continue;
            }
            retVals.put(dimensionValue, arg2Val);
        }
        DateTime timestamp = this.gran instanceof AllGranularity ? arg1.getTimestamp() : this.gran.toDateTime(this.gran.truncate(arg1.getTimestamp().getMillis()));
        TopNResultBuilder bob = this.topNMetricSpec.getResultBuilder(timestamp, this.dimSpec, this.threshold, this.comparator, this.aggregations, this.postAggregations);
        for (DimensionAndMetricValueExtractor extractor : retVals.values()) {
            bob.addEntry(extractor);
        }
        return bob.build();
    }
}

