/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Supplier;
import com.metamx.common.logger.Logger;
import com.ning.compress.BufferRecycler;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

public class CompressedPools {
    private static final Logger log = new Logger(CompressedPools.class);
    public static final int BUFFER_SIZE = 65536;
    private static final StupidPool<BufferRecycler> bufferRecyclerPool = new StupidPool((Supplier)new Supplier<BufferRecycler>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public BufferRecycler get() {
            log.info("Allocating new bufferRecycler[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new BufferRecycler();
        }
    });
    private static final StupidPool<byte[]> outputBytesPool = new StupidPool((Supplier)new Supplier<byte[]>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public byte[] get() {
            log.info("Allocating new outputBytesPool[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new byte[65536];
        }
    });
    private static final StupidPool<ByteBuffer> bigEndByteBufPool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new bigEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.BIG_ENDIAN);
        }
    });
    private static final StupidPool<ByteBuffer> littleEndByteBufPool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new littleEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65536).order(ByteOrder.LITTLE_ENDIAN);
        }
    });

    public static ResourceHolder<BufferRecycler> getBufferRecycler() {
        return bufferRecyclerPool.take();
    }

    public static ResourceHolder<byte[]> getOutputBytes() {
        return outputBytesPool.take();
    }

    public static ResourceHolder<ByteBuffer> getByteBuf(ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return littleEndByteBufPool.take();
        }
        return bigEndByteBufPool.take();
    }
}

