/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import com.metamx.common.ISE;
import com.metamx.common.io.smoosh.FileSmoosher;
import com.metamx.common.io.smoosh.SmooshedWriter;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.common.utils.JodaUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.FloatColumnSerializer;
import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.LongColumnSerializer;
import io.druid.segment.Metadata;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferWriter;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIndexedV3Writer;
import io.druid.segment.data.CompressedVSizeIntsIndexedWriter;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIntsWriter;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.TmpFileIOPeon;
import io.druid.segment.data.VSizeIndexedIntsWriter;
import io.druid.segment.data.VSizeIndexedWriter;
import io.druid.segment.serde.ComplexColumnPartSerde;
import io.druid.segment.serde.ComplexColumnSerializer;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import io.druid.segment.serde.FloatGenericColumnPartSerde;
import io.druid.segment.serde.LongGenericColumnPartSerde;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
extends IndexMerger {
    private static final Logger log = new Logger(IndexMergerV9.class);

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO) {
        super(mapper, indexIO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File makeIndexFiles(List<IndexableAdapter> adapters, AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        progress.start();
        progress.progress();
        List metadataList = Lists.transform(adapters, (Function)new Function<IndexableAdapter, Metadata>(){

            public Metadata apply(IndexableAdapter input) {
                return input.getMetadata();
            }
        });
        Metadata segmentMetadata = null;
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        Closer closer = Closer.create();
        final TmpFileIOPeon ioPeon = new TmpFileIOPeon(false);
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                ioPeon.cleanup();
            }
        });
        FileSmoosher v9Smoosher = new FileSmoosher(outDir);
        final File v9TmpDir = new File(outDir, "v9-tmp");
        v9TmpDir.mkdirs();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                FileUtils.deleteDirectory((File)v9TmpDir);
            }
        });
        log.info("Start making v9 index files, outDir:%s", new Object[]{outDir});
        try {
            long startTime = System.currentTimeMillis();
            ByteStreams.write((byte[])Ints.toByteArray((int)9), (OutputSupplier)Files.newOutputStreamSupplier((File)new File(outDir, "version.bin")));
            log.info("Completed version.bin in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
            progress.progress();
            TreeMap metricsValueTypes = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
            TreeMap metricTypeNames = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
            ArrayList dimCapabilities = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.mergeCapabilities(adapters, mergedDimensions, metricsValueTypes, metricTypeNames, dimCapabilities);
            progress.progress();
            startTime = System.currentTimeMillis();
            HashMap dimCardinalities = Maps.newHashMap();
            ArrayList<GenericIndexedWriter<String>> dimValueWriters = this.setupDimValueWriters(ioPeon, mergedDimensions);
            ArrayList dimConversions = Lists.newArrayListWithCapacity((int)adapters.size());
            ArrayList dimensionSkipFlag = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            ArrayList dimHasNullFlags = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            ArrayList convertMissingDimsFlags = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            this.writeDimValueAndSetupDimConversion(adapters, progress, mergedDimensions, dimCardinalities, dimValueWriters, dimensionSkipFlag, dimConversions, convertMissingDimsFlags, dimHasNullFlags);
            log.info("Completed dim conversions in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
            progress.progress();
            Iterable<Rowboat> theRows = this.makeRowIterable(adapters, mergedDimensions, mergedMetrics, dimConversions, convertMissingDimsFlags, rowMergerFn);
            LongColumnSerializer timeWriter = this.setupTimeWriter(ioPeon);
            ArrayList<IndexedIntsWriter> dimWriters = this.setupDimensionWriters(ioPeon, mergedDimensions, dimCapabilities, dimCardinalities, indexSpec);
            ArrayList<GenericColumnSerializer> metWriters = this.setupMetricsWriters(ioPeon, mergedMetrics, metricsValueTypes, metricTypeNames, indexSpec);
            ArrayList rowNumConversions = Lists.newArrayListWithCapacity((int)adapters.size());
            ArrayList nullRowsList = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                nullRowsList.add(indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap());
            }
            this.mergeIndexesAndWriteColumns(adapters, progress, theRows, timeWriter, dimWriters, metWriters, dimensionSkipFlag, rowNumConversions, nullRowsList, dimHasNullFlags);
            progress.progress();
            ArrayList<GenericIndexedWriter<ImmutableBitmap>> bitmapIndexWriters = this.setupBitmapIndexWriters(ioPeon, mergedDimensions, indexSpec);
            ArrayList<ByteBufferWriter<ImmutableRTree>> spatialIndexWriters = this.setupSpatialIndexWriters(ioPeon, mergedDimensions, indexSpec, dimCapabilities);
            this.makeInvertedIndexes(adapters, progress, mergedDimensions, indexSpec, v9TmpDir, rowNumConversions, nullRowsList, dimValueWriters, bitmapIndexWriters, spatialIndexWriters, dimConversions);
            progress.progress();
            this.makeTimeColumn(v9Smoosher, progress, timeWriter);
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricsValueTypes, metricTypeNames, metWriters);
            this.makeDimensionColumns(v9Smoosher, progress, indexSpec, mergedDimensions, dimensionSkipFlag, dimCapabilities, dimValueWriters, dimWriters, bitmapIndexWriters, spatialIndexWriters);
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, dimensionSkipFlag, mergedMetrics, progress, indexSpec);
            this.makeMetadataBinary(v9Smoosher, progress, segmentMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
        finally {
            closer.close();
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes((Object)segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, ArrayList<Boolean> dimensionSkipFlag, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec) throws IOException {
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        LinkedHashSet finalDimensions = Sets.newLinkedHashSet();
        LinkedHashSet finalColumns = Sets.newLinkedHashSet();
        finalColumns.addAll(mergedMetrics);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            if (dimensionSkipFlag.get(i).booleanValue()) continue;
            finalColumns.add(mergedDimensions.get(i));
            finalDimensions.add(mergedDimensions.get(i));
        }
        GenericIndexed<String> cols = GenericIndexed.fromIterable(finalColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> dims = GenericIndexed.fromIterable(finalDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory());
        long numBytes = cols.getSerializedSize() + dims.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(bitmapSerdeFactoryType);
        SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
        cols.writeToChannel((WritableByteChannel)writer);
        dims.writeToChannel((WritableByteChannel)writer);
        DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
        DateTime maxTime = new DateTime(-4611686018427387904L);
        for (IndexableAdapter index : adapters) {
            minTime = JodaUtils.minDateTime((DateTime[])new DateTime[]{minTime, index.getDataInterval().getStart()});
            maxTime = JodaUtils.maxDateTime((DateTime[])new DateTime[]{maxTime, index.getDataInterval().getEnd()});
        }
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getStartMillis());
        serializerUtils.writeLong((WritableByteChannel)writer, dataInterval.getEndMillis());
        serializerUtils.writeString((WritableByteChannel)writer, bitmapSerdeFactoryType);
        writer.close();
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.info("Completed index.drd in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make index.drd");
    }

    private void makeDimensionColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, IndexSpec indexSpec, List<String> mergedDimensions, ArrayList<Boolean> dimensionSkipFlag, List<ColumnCapabilitiesImpl> dimCapabilities, ArrayList<GenericIndexedWriter<String>> dimValueWriters, ArrayList<IndexedIntsWriter> dimWriters, ArrayList<GenericIndexedWriter<ImmutableBitmap>> bitmapIndexWriters, ArrayList<ByteBufferWriter<ImmutableRTree>> spatialIndexWriters) throws IOException {
        String section = "make dimension columns";
        progress.startSection("make dimension columns");
        long startTime = System.currentTimeMillis();
        BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
        CompressedObjectStrategy.CompressionStrategy compressionStrategy = indexSpec.getDimensionCompressionStrategy();
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            long dimStartTime = System.currentTimeMillis();
            String dim = mergedDimensions.get(i);
            IndexedIntsWriter dimWriter = dimWriters.get(i);
            GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = bitmapIndexWriters.get(i);
            ByteBufferWriter<ImmutableRTree> spatialIndexWriter = spatialIndexWriters.get(i);
            dimWriter.close();
            bitmapIndexWriter.close();
            if (spatialIndexWriter != null) {
                spatialIndexWriter.close();
            }
            if (dimensionSkipFlag.get(i).booleanValue()) continue;
            boolean hasMultiValue = dimCapabilities.get(i).hasMultipleValues();
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            builder.setValueType(ValueType.STRING);
            builder.setHasMultipleValues(hasMultiValue);
            DictionaryEncodedColumnPartSerde.SerializerBuilder partBuilder = DictionaryEncodedColumnPartSerde.serializerBuilder().withDictionary(dimValueWriters.get(i)).withValue(dimWriters.get(i), hasMultiValue, compressionStrategy != null).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmapIndex(bitmapIndexWriters.get(i)).withSpatialIndex(spatialIndexWriters.get(i)).withByteOrder(IndexIO.BYTE_ORDER);
            ColumnDescriptor serdeficator = builder.addSerde(partBuilder.build()).build();
            this.makeColumn(v9Smoosher, dim, serdeficator);
            log.info("Completed dimension column[%s] in %,d millis.", new Object[]{dim, System.currentTimeMillis() - dimStartTime});
        }
        log.info("Completed dimension columns in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make dimension columns");
    }

    private void makeMetricsColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<GenericColumnSerializer> metWriters) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            writer.close();
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((LongColumnSerializer)writer).build());
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(FloatGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((FloatColumnSerializer)writer).build());
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate((ComplexColumnSerializer)writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            this.makeColumn(v9Smoosher, metric, builder.build());
            log.info("Completed metric column[%s] in %,d millis.", new Object[]{metric, System.currentTimeMillis() - metricStartTime});
        }
        log.info("Completed metric columns in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make metric columns");
    }

    private void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, LongColumnSerializer timeWriter) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        timeWriter.close();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(timeWriter).build()).build();
        this.makeColumn(v9Smoosher, "__time", serdeficator);
        log.info("Completed time column in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("make time column");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeColumn(FileSmoosher v9Smoosher, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializerUtils.writeString((OutputStream)baos, this.mapper.writeValueAsString((Object)serdeficator));
        byte[] specBytes = baos.toByteArray();
        try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(columnName, serdeficator.numBytes() + (long)specBytes.length);){
            channel.write(ByteBuffer.wrap(specBytes));
            serdeficator.write((WritableByteChannel)channel);
        }
    }

    private void makeInvertedIndexes(List<IndexableAdapter> adapters, ProgressIndicator progress, List<String> mergedDimensions, IndexSpec indexSpec, File v9OutDir, List<IntBuffer> rowNumConversions, ArrayList<MutableBitmap> nullRowsList, ArrayList<GenericIndexedWriter<String>> dimValueWriters, ArrayList<GenericIndexedWriter<ImmutableBitmap>> bitmapIndexWriters, ArrayList<ByteBufferWriter<ImmutableRTree>> spatialIndexWriters, ArrayList<Map<String, IntBuffer>> dimConversions) throws IOException {
        String section = "build inverted index";
        progress.startSection("build inverted index");
        long startTime = System.currentTimeMillis();
        BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            String dimension = mergedDimensions.get(dimIndex);
            long dimStartTime = System.currentTimeMillis();
            File dimValueFile = IndexIO.makeDimFile(v9OutDir, dimension);
            FileOutputStream fos = new FileOutputStream(dimValueFile);
            ByteStreams.copy(dimValueWriters.get(dimIndex).combineStreams(), (OutputStream)fos);
            fos.close();
            MappedByteBuffer dimValsMapped = Files.map((File)dimValueFile);
            GenericIndexed<String> dimVals = GenericIndexed.read(dimValsMapped, GenericIndexed.STRING_STRATEGY);
            ByteBufferWriter<ImmutableRTree> spatialIndexWriter = spatialIndexWriters.get(dimIndex);
            RTree tree = null;
            if (spatialIndexWriter != null) {
                BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
            }
            IndexMerger.IndexSeeker[] dictIdSeeker = this.toIndexSeekers(adapters, dimConversions, dimension);
            ImmutableBitmap nullRowBitmap = bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(nullRowsList.get(dimIndex));
            for (int dictId = 0; dictId < dimVals.size(); ++dictId) {
                String dimVal;
                progress.progress();
                ArrayList convertedInverteds = Lists.newArrayListWithCapacity((int)adapters.size());
                for (int j = 0; j < adapters.size(); ++j) {
                    int seekedDictId = dictIdSeeker[j].seek(dictId);
                    if (seekedDictId == -1) continue;
                    convertedInverteds.add(new IndexMerger.ConvertingIndexedInts(adapters.get(j).getBitmapIndex(dimension, seekedDictId), rowNumConversions.get(j)));
                }
                MutableBitmap bitset = bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
                for (Integer row : CombiningIterable.createSplatted((Iterable)convertedInverteds, (Comparator)Ordering.natural().nullsFirst())) {
                    if (row == -1) continue;
                    bitset.add(row.intValue());
                }
                ImmutableBitmap bitmapToWrite = bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(bitset);
                if (dictId == 0 && Iterables.getFirst(dimVals, (Object)"") == null) {
                    bitmapToWrite = nullRowBitmap.union(bitmapToWrite);
                }
                bitmapIndexWriters.get(dimIndex).write(bitmapToWrite);
                if (spatialIndexWriter == null || (dimVal = (String)dimVals.get(dictId)) == null) continue;
                ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                float[] coords = new float[stringCoords.size()];
                for (int j = 0; j < coords.length; ++j) {
                    coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                }
                tree.insert(coords, bitset);
            }
            if (spatialIndexWriter != null) {
                spatialIndexWriter.write(ImmutableRTree.newImmutableFromMutable((RTree)tree));
            }
            log.info("Completed dim[%s] inverted with cardinality[%,d] in %,d millis.", new Object[]{dimension, dimVals.size(), System.currentTimeMillis() - dimStartTime});
        }
        log.info("Completed inverted index in %,d millis.", new Object[]{System.currentTimeMillis() - startTime});
        progress.stopSection("build inverted index");
    }

    private ArrayList<GenericIndexedWriter<ImmutableBitmap>> setupBitmapIndexWriters(IOPeon ioPeon, List<String> mergedDimensions, IndexSpec indexSpec) throws IOException {
        ArrayList writers = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
        for (String dimension : mergedDimensions) {
            GenericIndexedWriter<ImmutableBitmap> writer = new GenericIndexedWriter<ImmutableBitmap>(ioPeon, String.format("%s.inverted", dimension), bitmapSerdeFactory.getObjectStrategy());
            writer.open();
            writers.add(writer);
        }
        return writers;
    }

    private ArrayList<ByteBufferWriter<ImmutableRTree>> setupSpatialIndexWriters(IOPeon ioPeon, List<String> mergedDimensions, IndexSpec indexSpec, List<ColumnCapabilitiesImpl> dimCapabilities) throws IOException {
        ArrayList writers = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            if (dimCapabilities.get(dimIndex).hasSpatialIndexes()) {
                BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                ByteBufferWriter<ImmutableRTree> writer = new ByteBufferWriter<ImmutableRTree>(ioPeon, String.format("%s.spatial", mergedDimensions.get(dimIndex)), new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapFactory));
                writer.open();
                writers.add(writer);
                continue;
            }
            writers.add(null);
        }
        return writers;
    }

    private void mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, Iterable<Rowboat> theRows, LongColumnSerializer timeWriter, ArrayList<IndexedIntsWriter> dimWriters, ArrayList<GenericColumnSerializer> metWriters, ArrayList<Boolean> dimensionSkipFlag, List<IntBuffer> rowNumConversions, ArrayList<MutableBitmap> nullRowsList, ArrayList<Boolean> dimHasNullFlags) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        int rowCount = 0;
        for (IndexableAdapter adapter : adapters) {
            int[] arr = new int[adapter.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        long time = System.currentTimeMillis();
        for (Rowboat theRow : theRows) {
            progress.progress();
            timeWriter.serialize(theRow.getTimestamp());
            Object[] metrics = theRow.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                metWriters.get(i).serialize(metrics[i]);
            }
            int[][] dims = theRow.getDims();
            for (int i = 0; i < dims.length; ++i) {
                if (dimensionSkipFlag.get(i).booleanValue()) continue;
                if (dims[i] == null || dims[i].length == 0) {
                    nullRowsList.get(i).add(rowCount);
                } else if (dimHasNullFlags.get(i).booleanValue() && dims[i].length == 1 && dims[i][0] == 0) {
                    nullRowsList.get(i).add(rowCount);
                }
                dimWriters.get(i).add(dims[i]);
            }
            for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                IntBuffer conversionBuffer = rowNumConversions.get(comprisedRow.getKey());
                for (Integer rowNum : comprisedRow.getValue()) {
                    while (conversionBuffer.position() < rowNum) {
                        conversionBuffer.put(-1);
                    }
                    conversionBuffer.put(rowCount);
                }
            }
            if (++rowCount % 500000 != 0) continue;
            log.info("walked 500,000/%d rows in %,d millis.", new Object[]{rowCount, System.currentTimeMillis() - time});
            time = System.currentTimeMillis();
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        log.info("completed walk through of %,d rows in %,d millis.", new Object[]{rowCount, System.currentTimeMillis() - startTime});
        progress.stopSection("walk through and merge rows");
    }

    private LongColumnSerializer setupTimeWriter(IOPeon ioPeon) throws IOException {
        LongColumnSerializer timeWriter = LongColumnSerializer.create(ioPeon, "little_end_time", CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
        timeWriter.open();
        return timeWriter;
    }

    private ArrayList<GenericColumnSerializer> setupMetricsWriters(IOPeon ioPeon, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, IndexSpec indexSpec) throws IOException {
        ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
        CompressedObjectStrategy.CompressionStrategy metCompression = indexSpec.getMetricCompressionStrategy();
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    writer = LongColumnSerializer.create(ioPeon, metric, metCompression);
                    break;
                }
                case FLOAT: {
                    writer = FloatColumnSerializer.create(ioPeon, metric, metCompression);
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", new Object[]{typeName});
                    }
                    writer = ComplexColumnSerializer.create(ioPeon, metric, serde);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    private ArrayList<IndexedIntsWriter> setupDimensionWriters(IOPeon ioPeon, List<String> mergedDimensions, List<ColumnCapabilitiesImpl> dimCapabilities, Map<String, Integer> dimCardinalities, IndexSpec indexSpec) throws IOException {
        ArrayList dimWriters = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        CompressedObjectStrategy.CompressionStrategy dimCompression = indexSpec.getDimensionCompressionStrategy();
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            String dim = mergedDimensions.get(dimIndex);
            int cardinality = dimCardinalities.get(dim);
            ColumnCapabilitiesImpl capabilities = dimCapabilities.get(dimIndex);
            String filenameBase = String.format("%s.forward_dim", dim);
            IndexedIntsWriter writer = capabilities.hasMultipleValues() ? (dimCompression != null ? CompressedVSizeIndexedV3Writer.create(ioPeon, filenameBase, cardinality, dimCompression) : new VSizeIndexedWriter(ioPeon, filenameBase, cardinality)) : (dimCompression != null ? CompressedVSizeIntsIndexedWriter.create(ioPeon, filenameBase, cardinality, dimCompression) : new VSizeIndexedIntsWriter(ioPeon, filenameBase, cardinality));
            writer.open();
            dimWriters.add(writer);
        }
        return dimWriters;
    }

    private ArrayList<GenericIndexedWriter<String>> setupDimValueWriters(IOPeon ioPeon, List<String> mergedDimensions) throws IOException {
        ArrayList dimValueWriters = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
        for (String dimension : mergedDimensions) {
            GenericIndexedWriter<String> writer = new GenericIndexedWriter<String>(ioPeon, String.format("%s.dim_values", dimension), GenericIndexed.STRING_STRATEGY);
            writer.open();
            dimValueWriters.add(writer);
        }
        return dimValueWriters;
    }

    /*
     * WARNING - void declaration
     */
    private void writeDimValueAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, Map<String, Integer> dimensionCardinalities, ArrayList<GenericIndexedWriter<String>> dimValueWriters, ArrayList<Boolean> dimensionSkipFlag, List<Map<String, IntBuffer>> dimConversions, ArrayList<Boolean> convertMissingDimsFlags, ArrayList<Boolean> dimHasNullFlags) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int i = 0; i < indexes.size(); ++i) {
            dimConversions.add(Maps.newHashMap());
        }
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            long dimStartTime = System.currentTimeMillis();
            String dimension = mergedDimensions.get(dimIndex);
            boolean dimHasNull = false;
            boolean dimHasValues = false;
            boolean dimAbsentFromSomeIndex = false;
            int numMergeIndex = 0;
            Indexed<Object> dimValueLookup = null;
            Indexed[] dimValueLookups = new Indexed[indexes.size() + 1];
            for (int i = 0; i < indexes.size(); ++i) {
                Indexed<String> dimValues = indexes.get(i).getDimValueLookup(dimension);
                if (!IndexMergerV9.isNullColumn(dimValues)) {
                    dimHasValues = true;
                    dimHasNull |= dimValues.indexOf(null) >= 0;
                    dimValueLookup = dimValues;
                    dimValueLookups[i] = dimValueLookup;
                    ++numMergeIndex;
                    continue;
                }
                dimAbsentFromSomeIndex = true;
            }
            boolean convertMissingDims = dimHasValues && dimAbsentFromSomeIndex;
            convertMissingDimsFlags.add(convertMissingDims);
            if (convertMissingDims && !dimHasNull) {
                dimHasNull = true;
                dimValueLookup = EMPTY_STR_DIM_VAL;
                dimValueLookups[indexes.size()] = dimValueLookup;
                ++numMergeIndex;
            }
            GenericIndexedWriter<String> writer = dimValueWriters.get(dimIndex);
            int cardinality = 0;
            if (numMergeIndex > 1) {
                void var25_25;
                IndexMerger.DictionaryMergeIterator iterator = new IndexMerger.DictionaryMergeIterator(dimValueLookups, true);
                while (iterator.hasNext()) {
                    writer.write(iterator.next());
                }
                boolean bl = false;
                while (var25_25 < indexes.size()) {
                    if (dimValueLookups[var25_25] != null && iterator.needConversion((int)var25_25)) {
                        dimConversions.get((int)var25_25).put(dimension, iterator.conversions[var25_25]);
                    }
                    ++var25_25;
                }
                cardinality = iterator.counter;
            } else if (numMergeIndex == 1) {
                for (String string : dimValueLookup) {
                    writer.write(string);
                }
                cardinality = dimValueLookup.size();
            }
            dimHasNullFlags.add(dimHasNull);
            log.info("Completed dim[%s] conversions with cardinality[%,d] in %,d millis.", new Object[]{dimension, cardinality, System.currentTimeMillis() - dimStartTime});
            dimensionCardinalities.put(dimension, cardinality);
            writer.close();
            if (cardinality == 0) {
                log.info(String.format("Skipping [%s], it is empty!", dimension), new Object[0]);
                dimensionSkipFlag.add(true);
                continue;
            }
            dimensionSkipFlag.add(false);
        }
        progress.stopSection("setup dimension conversions");
    }

    private void mergeCapabilities(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<ColumnCapabilitiesImpl> dimCapabilities) {
        HashMap capabilitiesMap = Maps.newHashMap();
        for (IndexableAdapter adapter : adapters) {
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(ValueType.STRING);
                }
                capabilitiesMap.put(dimension, mergedCapabilities.merge(adapter.getCapabilities(dimension)));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(metric);
                ColumnCapabilities capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                capabilitiesMap.put(metric, mergedCapabilities.merge(capabilities));
                metricsValueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        for (String dim : mergedDimensions) {
            dimCapabilities.add((ColumnCapabilitiesImpl)capabilitiesMap.get(dim));
        }
    }
}

