/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.segment.BaseProgressIndicator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LoggingProgressIndicator
extends BaseProgressIndicator {
    private static Logger log = new Logger(LoggingProgressIndicator.class);
    private final String progressName;
    private final Stopwatch global;
    private final Map<String, Stopwatch> sections = Maps.newHashMap();

    public LoggingProgressIndicator(String progressName) {
        this.progressName = progressName;
        this.global = Stopwatch.createUnstarted();
    }

    @Override
    public void start() {
        log.info("Starting [%s]", new Object[]{this.progressName});
        this.global.start();
    }

    @Override
    public void stop() {
        long time = this.global.elapsed(TimeUnit.MILLISECONDS);
        this.global.stop();
        log.info("[%s] complete. Elapsed time: [%,d] millis", new Object[]{this.progressName, time});
    }

    @Override
    public void startSection(String section) {
        log.info("[%s]: Starting [%s]", new Object[]{this.progressName, section});
        Stopwatch sectionWatch = this.sections.get(section);
        if (sectionWatch != null) {
            throw new ISE("[%s]: Cannot start progress tracker for [%s]. It is already started.", new Object[]{this.progressName, section});
        }
        sectionWatch = Stopwatch.createStarted();
        this.sections.put(section, sectionWatch);
    }

    @Override
    public void progressSection(String section, String message) {
        Stopwatch sectionWatch = this.sections.get(section);
        if (sectionWatch == null) {
            throw new ISE("[%s]: Cannot progress tracker for [%s]. Nothing started.", new Object[]{this.progressName, section});
        }
        long time = sectionWatch.elapsed(TimeUnit.MILLISECONDS);
        log.info("[%s]: [%s] : %s. Elapsed time: [%,d] millis", new Object[]{this.progressName, section, message, time});
    }

    @Override
    public void stopSection(String section) {
        Stopwatch sectionWatch = this.sections.remove(section);
        if (sectionWatch == null) {
            throw new ISE("[%s]: Cannot stop progress tracker for [%s]. Nothing started.", new Object[]{this.progressName, section});
        }
        long time = sectionWatch.elapsed(TimeUnit.MILLISECONDS);
        sectionWatch.stop();
        log.info("[%s]: [%s] has completed. Elapsed time: [%,d] millis", new Object[]{this.progressName, section, time});
    }
}

