/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.collect.Ordering;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.FixedSizeCompressedObjectStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class CompressedIntBufferObjectStrategy
extends FixedSizeCompressedObjectStrategy<IntBuffer> {
    public static final Ordering<Comparable> ORDERING = Ordering.natural().nullsFirst();

    public static CompressedIntBufferObjectStrategy getBufferForOrder(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        return new CompressedIntBufferObjectStrategy(order, compression, sizePer);
    }

    private CompressedIntBufferObjectStrategy(ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression, int sizePer) {
        super(order, new CompressedObjectStrategy.BufferConverter<IntBuffer>(){

            @Override
            public IntBuffer convert(ByteBuffer buf) {
                return buf.asIntBuffer();
            }

            @Override
            public int compare(IntBuffer lhs, IntBuffer rhs) {
                return ORDERING.compare((Object)lhs, (Object)rhs);
            }

            @Override
            public int sizeOf(int count) {
                return count * 4;
            }

            @Override
            public IntBuffer combine(ByteBuffer into, IntBuffer from) {
                return into.asIntBuffer().put(from);
            }
        }, compression, sizePer);
    }
}

