/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedLongBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CompressedLongsSupplierSerializer {
    private final int sizePer;
    private final GenericIndexedWriter<ResourceHolder<LongBuffer>> flattener;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private int numInserted = 0;
    private LongBuffer endBuffer;

    public static CompressedLongsSupplierSerializer create(IOPeon ioPeon, String filenameBase, ByteOrder order, CompressedObjectStrategy.CompressionStrategy compression) throws IOException {
        CompressedLongsSupplierSerializer retVal = new CompressedLongsSupplierSerializer(8192, new GenericIndexedWriter<ResourceHolder<LongBuffer>>(ioPeon, filenameBase, CompressedLongBufferObjectStrategy.getBufferForOrder(order, compression, 8192)), compression);
        return retVal;
    }

    public CompressedLongsSupplierSerializer(int sizePer, GenericIndexedWriter<ResourceHolder<LongBuffer>> flattener, CompressedObjectStrategy.CompressionStrategy compression) {
        this.sizePer = sizePer;
        this.flattener = flattener;
        this.compression = compression;
        this.endBuffer = LongBuffer.allocate(sizePer);
        this.endBuffer.mark();
    }

    public void open() throws IOException {
        this.flattener.open();
    }

    public int size() {
        return this.numInserted;
    }

    public void add(long value) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<LongBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = LongBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
        }
        this.endBuffer.put(value);
        ++this.numInserted;
    }

    public void closeAndConsolidate(OutputSupplier<? extends OutputStream> consolidatedOut) throws IOException {
        this.close();
        try (OutputStream out = (OutputStream)consolidatedOut.getOutput();){
            out.write(2);
            out.write(Ints.toByteArray((int)this.numInserted));
            out.write(Ints.toByteArray((int)this.sizePer));
            out.write(new byte[]{this.compression.getId()});
            ByteStreams.copy(this.flattener.combineStreams(), (OutputStream)out);
        }
    }

    public void close() throws IOException {
        this.endBuffer.limit(this.endBuffer.position());
        this.endBuffer.rewind();
        this.flattener.write((ResourceHolder<LongBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
        this.endBuffer = null;
        this.flattener.close();
    }

    public long getSerializedSize() {
        return 10L + this.flattener.getSerializedSize();
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.numInserted)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        ReadableByteChannel from = Channels.newChannel((InputStream)this.flattener.combineStreams().getInput());
        ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
    }
}

