/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import io.druid.segment.data.Offset;

public class IntersectingOffset
implements Offset {
    private final Offset lhs;
    private final Offset rhs;

    public IntersectingOffset(Offset lhs, Offset rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.findIntersection();
    }

    @Override
    public int getOffset() {
        return this.lhs.getOffset();
    }

    @Override
    public void increment() {
        this.lhs.increment();
        this.rhs.increment();
        this.findIntersection();
    }

    private void findIntersection() {
        if (!this.lhs.withinBounds() || !this.rhs.withinBounds()) {
            return;
        }
        int lhsOffset = this.lhs.getOffset();
        int rhsOffset = this.rhs.getOffset();
        while (lhsOffset != rhsOffset) {
            while (lhsOffset < rhsOffset) {
                this.lhs.increment();
                if (!this.lhs.withinBounds()) {
                    return;
                }
                lhsOffset = this.lhs.getOffset();
            }
            while (rhsOffset < lhsOffset) {
                this.rhs.increment();
                if (!this.rhs.withinBounds()) {
                    return;
                }
                rhsOffset = this.rhs.getOffset();
            }
        }
    }

    @Override
    public boolean withinBounds() {
        return this.lhs.withinBounds() && this.rhs.withinBounds();
    }

    @Override
    public Offset clone() {
        Offset lhsClone = this.lhs.clone();
        Offset rhsClone = this.rhs.clone();
        return new IntersectingOffset(lhsClone, rhsClone);
    }
}

