/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Ints;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.MultiValueIndexedIntsWriter;
import io.druid.segment.data.VSizeIndexedInts;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;

public class VSizeIndexedWriter
extends MultiValueIndexedIntsWriter
implements Closeable {
    private static final byte VERSION = 1;
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final int maxId;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valuesOut = null;
    int numWritten = 0;
    private final IOPeon ioPeon;
    private final String metaFileName;
    private final String headerFileName;
    private final String valuesFileName;

    public VSizeIndexedWriter(IOPeon ioPeon, String filenameBase, int maxId) {
        this.ioPeon = ioPeon;
        this.metaFileName = String.format("%s.meta", filenameBase);
        this.headerFileName = String.format("%s.header", filenameBase);
        this.valuesFileName = String.format("%s.values", filenameBase);
        this.maxId = maxId;
    }

    @Override
    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.headerFileName));
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.valuesFileName));
    }

    @Override
    protected void addValues(List<Integer> val) throws IOException {
        this.write(val);
    }

    public void write(List<Integer> ints) throws IOException {
        byte[] bytesToWrite = ints == null ? EMPTY_ARRAY : VSizeIndexedInts.getBytesNoPaddingfromList(ints, this.maxId);
        this.valuesOut.write(bytesToWrite);
        this.headerOut.write(Ints.toByteArray((int)((int)this.valuesOut.getCount())));
        ++this.numWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        byte numBytesForMax = VSizeIndexedInts.getNumBytesForMax(this.maxId);
        this.valuesOut.write(new byte[4 - numBytesForMax]);
        Closeables.close((Closeable)this.headerOut, (boolean)false);
        Closeables.close((Closeable)this.valuesOut, (boolean)false);
        long numBytesWritten = this.headerOut.getCount() + this.valuesOut.getCount();
        Preconditions.checkState((this.headerOut.getCount() == (long)(this.numWritten * 4) ? 1 : 0) != 0, (String)"numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", (Object[])new Object[]{this.numWritten, this.numWritten * 4, this.headerOut.getCount()});
        Preconditions.checkState((numBytesWritten < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Wrote[%s] bytes, which is too many.", (Object[])new Object[]{numBytesWritten});
        try (OutputStream metaOut = this.ioPeon.makeOutputStream(this.metaFileName);){
            metaOut.write(new byte[]{1, numBytesForMax});
            metaOut.write(Ints.toByteArray((int)((int)numBytesWritten + 4)));
            metaOut.write(Ints.toByteArray((int)this.numWritten));
        }
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join((Iterable)Iterables.transform(Arrays.asList(this.metaFileName, this.headerFileName, this.valuesFileName), (Function)new Function<String, InputSupplier<InputStream>>(){

            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return VSizeIndexedWriter.this.ioPeon.makeInputStream(input);
                    }
                };
            }
        }));
    }

    @Override
    public long getSerializedSize() {
        return 10L + this.headerOut.getCount() + this.valuesOut.getCount();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        ReadableByteChannel from = Channels.newChannel((InputStream)this.combineStreams().getInput());
        ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
    }
}

