/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.data.Indexed;
import java.util.Iterator;
import java.util.List;

public class Filters {
    public static List<Filter> toFilters(List<DimFilter> dimFilters) {
        return ImmutableList.copyOf((Iterable)FunctionalIterable.create(dimFilters).transform((Function)new Function<DimFilter, Filter>(){

            public Filter apply(DimFilter input) {
                return input.toFilter();
            }
        }));
    }

    public static Filter toFilter(DimFilter dimFilter) {
        return dimFilter == null ? null : dimFilter.toFilter();
    }

    public static ImmutableBitmap matchPredicate(String dimension, BitmapIndexSelector selector, final Predicate<String> predicate) {
        Preconditions.checkNotNull((Object)dimension, (Object)"dimension");
        Preconditions.checkNotNull((Object)selector, (Object)"selector");
        Preconditions.checkNotNull(predicate, (Object)"predicate");
        final Indexed<String> dimValues = selector.getDimensionValues(dimension);
        if (dimValues == null || dimValues.size() == 0) {
            if (predicate.apply(null)) {
                return selector.getBitmapFactory().complement(selector.getBitmapFactory().makeEmptyImmutableBitmap(), selector.getNumRows());
            }
            return selector.getBitmapFactory().makeEmptyImmutableBitmap();
        }
        final BitmapIndex bitmapIndex = selector.getBitmapIndex(dimension);
        return selector.getBitmapFactory().union((Iterable)new Iterable<ImmutableBitmap>(){

            @Override
            public Iterator<ImmutableBitmap> iterator() {
                return new Iterator<ImmutableBitmap>(){
                    int currIndex = 0;

                    @Override
                    public boolean hasNext() {
                        return this.currIndex < bitmapIndex.getCardinality();
                    }

                    @Override
                    public ImmutableBitmap next() {
                        while (this.currIndex < bitmapIndex.getCardinality() && !predicate.apply(dimValues.get(this.currIndex))) {
                            ++this.currIndex;
                        }
                        if (this.currIndex == bitmapIndex.getCardinality()) {
                            return bitmapIndex.getBitmapFactory().makeEmptyImmutableBitmap();
                        }
                        return bitmapIndex.getBitmap(this.currIndex++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }
}

