/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.metamx.collections.bitmap.ImmutableBitmap;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.filter.Filters;
import java.util.Set;

public class InFilter
implements Filter {
    private final String dimension;
    private final Set<String> values;
    private final ExtractionFn extractionFn;

    public InFilter(String dimension, Set<String> values, ExtractionFn extractionFn) {
        this.dimension = dimension;
        this.values = values;
        this.extractionFn = extractionFn;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(final BitmapIndexSelector selector) {
        if (this.extractionFn == null) {
            return selector.getBitmapFactory().union(Iterables.transform(this.values, (Function)new Function<String, ImmutableBitmap>(){

                public ImmutableBitmap apply(String value) {
                    return selector.getBitmapIndex(InFilter.this.dimension, value);
                }
            }));
        }
        return Filters.matchPredicate(this.dimension, selector, new Predicate<String>(){

            public boolean apply(String input) {
                return InFilter.this.values.contains(Strings.nullToEmpty((String)InFilter.this.extractionFn.apply(input)));
            }
        });
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                if (InFilter.this.extractionFn != null) {
                    input = InFilter.this.extractionFn.apply(input);
                }
                return InFilter.this.values.contains(Strings.nullToEmpty((String)input));
            }
        });
    }
}

