/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.ComplexColumnSerializer;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ComplexColumnPartSerde
implements ColumnPartSerde {
    private final String typeName;
    private final ComplexMetricSerde serde;
    private final ColumnPartSerde.Serializer serializer;

    @JsonCreator
    public static ComplexColumnPartSerde createDeserializer(@JsonProperty(value="typeName") String complexType) {
        return new ComplexColumnPartSerde(complexType, null);
    }

    private ComplexColumnPartSerde(String typeName, ColumnPartSerde.Serializer serializer) {
        this.typeName = typeName;
        this.serde = ComplexMetrics.getSerdeForType(typeName);
        this.serializer = serializer;
    }

    @JsonProperty
    public String getTypeName() {
        return this.typeName;
    }

    public static SerializerBuilder serializerBuilder() {
        return new SerializerBuilder();
    }

    public static LegacySerializerBuilder legacySerializerBuilder() {
        return new LegacySerializerBuilder();
    }

    @Override
    public ColumnPartSerde.Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public ColumnPartSerde.Deserializer getDeserializer() {
        return new ColumnPartSerde.Deserializer(){

            @Override
            public void read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
                if (ComplexColumnPartSerde.this.serde != null) {
                    ComplexColumnPartSerde.this.serde.deserializeColumn(buffer, builder);
                }
            }
        };
    }

    public static class LegacySerializerBuilder {
        private String typeName = null;
        private GenericIndexed delegate = null;

        public LegacySerializerBuilder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public LegacySerializerBuilder withDelegate(GenericIndexed delegate) {
            this.delegate = delegate;
            return this;
        }

        public ComplexColumnPartSerde build() {
            return new ComplexColumnPartSerde(this.typeName, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return LegacySerializerBuilder.this.delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    LegacySerializerBuilder.this.delegate.writeToChannel(channel);
                }
            });
        }
    }

    public static class SerializerBuilder {
        private String typeName = null;
        private ComplexColumnSerializer delegate = null;

        public SerializerBuilder withTypeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public SerializerBuilder withDelegate(ComplexColumnSerializer delegate) {
            this.delegate = delegate;
            return this;
        }

        public ComplexColumnPartSerde build() {
            return new ComplexColumnPartSerde(this.typeName, new ColumnPartSerde.Serializer(){

                @Override
                public long numBytes() {
                    return SerializerBuilder.this.delegate.getSerializedSize();
                }

                @Override
                public void write(WritableByteChannel channel) throws IOException {
                    SerializerBuilder.this.delegate.writeToChannel(channel);
                }
            });
        }
    }
}

