/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import io.druid.query.aggregation.AggregatorFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class QueryCacheHelper {
    public static byte[] computeAggregatorBytes(List<AggregatorFactory> aggregatorSpecs) {
        ArrayList cacheKeySet = Lists.newArrayListWithCapacity((int)aggregatorSpecs.size());
        int totalSize = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            byte[] cacheKey = spec.getCacheKey();
            cacheKeySet.add(cacheKey);
            totalSize += cacheKey.length;
        }
        ByteBuffer retVal = ByteBuffer.allocate(totalSize);
        for (byte[] bytes : cacheKeySet) {
            retVal.put(bytes);
        }
        return retVal.array();
    }
}

