/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import java.util.Comparator;

public class ResultGranularTimestampComparator<T>
implements Comparator<Result<T>> {
    private final QueryGranularity gran;

    public ResultGranularTimestampComparator(QueryGranularity granularity) {
        this.gran = granularity;
    }

    @Override
    public int compare(Result<T> r1, Result<T> r2) {
        return Longs.compare((long)this.gran.truncate(r1.getTimestamp().getMillis()), (long)this.gran.truncate(r2.getTimestamp().getMillis()));
    }

    public static <T> Ordering<Result<T>> create(QueryGranularity granularity, boolean descending) {
        ResultGranularTimestampComparator<T> comparator = new ResultGranularTimestampComparator<T>(granularity);
        return descending ? Ordering.from(comparator).reverse() : Ordering.from(comparator);
    }
}

