/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.segment.FloatColumnSelector;
import java.nio.ByteBuffer;

public class DoubleMaxBufferAggregator
implements BufferAggregator {
    private final FloatColumnSelector selector;

    public DoubleMaxBufferAggregator(FloatColumnSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putDouble(position, Double.NEGATIVE_INFINITY);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        buf.putDouble(position, Math.max(buf.getDouble(position), (double)this.selector.get()));
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getDouble(position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return (float)buf.getDouble(position);
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        return (long)buf.getDouble(position);
    }

    @Override
    public void close() {
    }
}

