/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.FloatColumnSelector;
import java.util.Comparator;

public class DoubleSumAggregator
implements Aggregator {
    static final Comparator COMPARATOR = new Ordering(){

        public int compare(Object o, Object o1) {
            return Doubles.compare((double)((Number)o).doubleValue(), (double)((Number)o1).doubleValue());
        }
    }.nullsFirst();
    private final FloatColumnSelector selector;
    private final String name;
    private double sum;

    static double combineValues(Object lhs, Object rhs) {
        return ((Number)lhs).doubleValue() + ((Number)rhs).doubleValue();
    }

    public DoubleSumAggregator(String name, FloatColumnSelector selector) {
        this.name = name;
        this.selector = selector;
        this.sum = 0.0;
    }

    @Override
    public void aggregate() {
        this.sum += (double)this.selector.get();
    }

    @Override
    public void reset() {
        this.sum = 0.0;
    }

    @Override
    public Object get() {
        return this.sum;
    }

    @Override
    public float getFloat() {
        return (float)this.sum;
    }

    @Override
    public long getLong() {
        return (long)this.sum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new DoubleSumAggregator(this.name, this.selector);
    }

    @Override
    public void close() {
    }
}

