/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import io.druid.js.JavaScriptConfig;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.DoubleSumAggregator;
import io.druid.query.aggregation.JavaScriptAggregator;
import io.druid.query.aggregation.JavaScriptBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ObjectColumnSelector;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 6;
    private final String name;
    private final List<String> fieldNames;
    private final String fnAggregate;
    private final String fnReset;
    private final String fnCombine;
    private final JavaScriptConfig config;
    private final JavaScriptAggregator.ScriptAggregator compiledScript;

    @JsonCreator
    public JavaScriptAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fnAggregate") String fnAggregate, @JsonProperty(value="fnReset") String fnReset, @JsonProperty(value="fnCombine") String fnCombine, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldNames, (Object)"Must have a valid, non-null fieldNames");
        Preconditions.checkNotNull((Object)fnAggregate, (Object)"Must have a valid, non-null fnAggregate");
        Preconditions.checkNotNull((Object)fnReset, (Object)"Must have a valid, non-null fnReset");
        Preconditions.checkNotNull((Object)fnCombine, (Object)"Must have a valid, non-null fnCombine");
        this.name = name;
        this.fieldNames = fieldNames;
        this.fnAggregate = fnAggregate;
        this.fnReset = fnReset;
        this.fnCombine = fnCombine;
        this.config = config;
        this.compiledScript = config.isDisabled() ? null : JavaScriptAggregatorFactory.compileScript(fnAggregate, fnReset, fnCombine);
    }

    @Override
    public Aggregator factorize(final ColumnSelectorFactory columnFactory) {
        return new JavaScriptAggregator(this.name, Lists.transform(this.fieldNames, (Function)new Function<String, ObjectColumnSelector>(){

            public ObjectColumnSelector apply(@Nullable String s) {
                return columnFactory.makeObjectColumnSelector(s);
            }
        }), this.getCompiledScript());
    }

    @Override
    public BufferAggregator factorizeBuffered(final ColumnSelectorFactory columnSelectorFactory) {
        return new JavaScriptBufferAggregator(Lists.transform(this.fieldNames, (Function)new Function<String, ObjectColumnSelector>(){

            public ObjectColumnSelector apply(@Nullable String s) {
                return columnSelectorFactory.makeObjectColumnSelector(s);
            }
        }), this.getCompiledScript());
    }

    @Override
    public Comparator getComparator() {
        return DoubleSumAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return this.getCompiledScript().combine(((Number)lhs).doubleValue(), ((Number)rhs).doubleValue());
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new JavaScriptAggregatorFactory(this.name, Lists.newArrayList((Object[])new String[]{this.name}), this.fnCombine, this.fnReset, this.fnCombine, this.config);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && other.getClass() == this.getClass()) {
            JavaScriptAggregatorFactory castedOther = (JavaScriptAggregatorFactory)other;
            if (this.fnCombine.equals(castedOther.fnCombine) && this.fnReset.equals(castedOther.fnReset)) {
                return this.getCombiningFactory();
            }
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return ImmutableList.copyOf((Collection)Lists.transform(this.fieldNames, (Function)new Function<String, AggregatorFactory>(){

            public AggregatorFactory apply(String input) {
                return new JavaScriptAggregatorFactory(input, JavaScriptAggregatorFactory.this.fieldNames, JavaScriptAggregatorFactory.this.fnAggregate, JavaScriptAggregatorFactory.this.fnReset, JavaScriptAggregatorFactory.this.fnCombine, JavaScriptAggregatorFactory.this.config);
            }
        }));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty
    public String getFnAggregate() {
        return this.fnAggregate;
    }

    @JsonProperty
    public String getFnReset() {
        return this.fnReset;
    }

    @JsonProperty
    public String getFnCombine() {
        return this.fnCombine;
    }

    @Override
    public List<String> requiredFields() {
        return this.fieldNames;
    }

    @Override
    public byte[] getCacheKey() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] fieldNameBytes = StringUtils.toUtf8((String)Joiner.on((String)",").join(this.fieldNames));
            byte[] sha1 = md.digest(StringUtils.toUtf8((String)(this.fnAggregate + this.fnReset + this.fnCombine)));
            return ByteBuffer.allocate(1 + fieldNameBytes.length + sha1.length).put((byte)6).put(fieldNameBytes).put(sha1).array();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get SHA1 digest instance", e);
        }
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return this.getCompiledScript().reset();
    }

    public String toString() {
        return "JavaScriptAggregatorFactory{name='" + this.name + '\'' + ", fieldNames=" + this.fieldNames + ", fnAggregate='" + this.fnAggregate + '\'' + ", fnReset='" + this.fnReset + '\'' + ", fnCombine='" + this.fnCombine + '\'' + '}';
    }

    private JavaScriptAggregator.ScriptAggregator getCompiledScript() {
        if (this.compiledScript == null) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        return this.compiledScript;
    }

    @VisibleForTesting
    static JavaScriptAggregator.ScriptAggregator compileScript(String aggregate, String reset, String combine) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fnAggregate = context.compileFunction((Scriptable)scope, aggregate, "aggregate", 1, null);
        final org.mozilla.javascript.Function fnReset = context.compileFunction((Scriptable)scope, reset, "reset", 1, null);
        final org.mozilla.javascript.Function fnCombine = context.compileFunction((Scriptable)scope, combine, "combine", 1, null);
        Context.exit();
        return new JavaScriptAggregator.ScriptAggregator(){

            @Override
            public double aggregate(double current, ObjectColumnSelector[] selectorList) {
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                    cx.getWrapFactory().setJavaPrimitiveWrap(false);
                }
                int size = selectorList.length;
                Object[] args = new Object[size + 1];
                args[0] = current;
                for (int i = 0; i < size; ++i) {
                    ObjectColumnSelector selector = selectorList[i];
                    if (selector == null) continue;
                    Object arg = selector.get();
                    if (arg != null && arg.getClass().isArray()) {
                        Object[] arrayAsObjectArray = new Object[Array.getLength(arg)];
                        for (int j = 0; j < Array.getLength(arg); ++j) {
                            arrayAsObjectArray[j] = Array.get(arg, j);
                        }
                        args[i + 1] = cx.newArray((Scriptable)scope, arrayAsObjectArray);
                        continue;
                    }
                    args[i + 1] = Context.javaToJS(arg, (Scriptable)scope);
                }
                Object res = fnAggregate.call(cx, (Scriptable)scope, (Scriptable)scope, args);
                return Context.toNumber((Object)res);
            }

            @Override
            public double combine(final double a, final double b) {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnCombine.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[]{a, b});
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public double reset() {
                Object res = contextFactory.call(new ContextAction(){

                    public Object run(Context cx) {
                        return fnReset.call(cx, (Scriptable)scope, (Scriptable)scope, new Object[0]);
                    }
                });
                return Context.toNumber((Object)res);
            }

            @Override
            public void close() {
                if (Context.getCurrentContext() != null) {
                    Context.exit();
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptAggregatorFactory that = (JavaScriptAggregatorFactory)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.fieldNames, that.fieldNames) && Objects.equals(this.fnAggregate, that.fnAggregate) && Objects.equals(this.fnReset, that.fnReset) && Objects.equals(this.fnCombine, that.fnCombine);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldNames, this.fnAggregate, this.fnReset, this.fnCombine);
    }
}

