/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.guava.ResourceClosingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.collections.StupidPool;
import io.druid.data.input.Row;
import io.druid.guice.annotations.Global;
import io.druid.query.GroupByMergedQueryRunner;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.query.groupby.strategy.GroupByStrategy;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.segment.StorageAdapter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.joda.time.Interval;

public class GroupByStrategyV1
implements GroupByStrategy {
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final GroupByQueryEngine engine;
    private final QueryWatcher queryWatcher;
    private final StupidPool<ByteBuffer> bufferPool;

    @Inject
    public GroupByStrategyV1(Supplier<GroupByQueryConfig> configSupplier, GroupByQueryEngine engine, QueryWatcher queryWatcher, @Global StupidPool<ByteBuffer> bufferPool) {
        this.configSupplier = configSupplier;
        this.engine = engine;
        this.queryWatcher = queryWatcher;
        this.bufferPool = bufferPool;
    }

    @Override
    public Sequence<Row> mergeResults(QueryRunner<Row> baseRunner, GroupByQuery query, Map<String, Object> responseContext) {
        IncrementalIndex index = GroupByQueryHelper.makeIncrementalIndex(query, (GroupByQueryConfig)this.configSupplier.get(), this.bufferPool, baseRunner.run(new GroupByQuery(query.getDataSource(), query.getQuerySegmentSpec(), query.getDimFilter(), query.getGranularity(), query.getDimensions(), query.getAggregatorSpecs(), (List<PostAggregator>)ImmutableList.of(), null, null, query.getContext()).withOverriddenContext((Map)ImmutableMap.of((Object)"finalize", (Object)false, (Object)"sortResults", (Object)false, (Object)"groupByMerge", (Object)false, (Object)"groupByStrategy", (Object)"v1")), responseContext));
        return new ResourceClosingSequence(query.applyLimit(GroupByQueryHelper.postAggregate(query, index)), (Closeable)index);
    }

    @Override
    public Sequence<Row> processSubqueryResult(GroupByQuery subquery, GroupByQuery query, Sequence<Row> subqueryResult) {
        HashSet aggs = Sets.newHashSet();
        for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
            for (final AggregatorFactory transferAgg : aggregatorFactory.getRequiredColumns()) {
                if (Iterables.any((Iterable)aggs, (Predicate)new Predicate<AggregatorFactory>(){

                    public boolean apply(AggregatorFactory agg) {
                        return agg.getName().equals(transferAgg.getName()) && !agg.equals(transferAgg);
                    }
                })) {
                    throw new IAE("Inner aggregator can currently only be referenced by a single type of outer aggregator for '%s'", new Object[]{transferAgg.getName()});
                }
                aggs.add(transferAgg);
            }
        }
        GroupByQuery innerQuery = new GroupByQuery.Builder(subquery).setAggregatorSpecs(Lists.newArrayList((Iterable)aggs)).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(Lists.newArrayList()).build();
        final GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
        final IncrementalIndex innerQueryResultIndex = this.makeIncrementalIndex((GroupByQuery)innerQuery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)true)), subqueryResult);
        IncrementalIndex outerQueryResultIndex = this.makeIncrementalIndex(outerQuery, (Sequence<Row>)Sequences.concat((Sequence)Sequences.map((Sequence)Sequences.simple(outerQuery.getIntervals()), (Function)new Function<Interval, Sequence<Row>>(){

            public Sequence<Row> apply(Interval interval) {
                return GroupByStrategyV1.this.process(outerQuery.withQuerySegmentSpec(new MultipleIntervalSegmentSpec((List<Interval>)ImmutableList.of((Object)interval))), new IncrementalIndexStorageAdapter(innerQueryResultIndex));
            }
        })));
        innerQueryResultIndex.close();
        return new ResourceClosingSequence(outerQuery.applyLimit(GroupByQueryHelper.postAggregate(query, outerQueryResultIndex)), (Closeable)outerQueryResultIndex);
    }

    private IncrementalIndex makeIncrementalIndex(GroupByQuery query, Sequence<Row> rows) {
        return GroupByQueryHelper.makeIncrementalIndex(query, (GroupByQueryConfig)this.configSupplier.get(), this.bufferPool, rows);
    }

    @Override
    public QueryRunner<Row> mergeRunners(ListeningExecutorService exec, Iterable<QueryRunner<Row>> queryRunners) {
        return new GroupByMergedQueryRunner<Row>((ExecutorService)exec, this.configSupplier, this.queryWatcher, this.bufferPool, queryRunners);
    }

    @Override
    public Sequence<Row> process(GroupByQuery query, StorageAdapter storageAdapter) {
        return this.engine.process(query, storageAdapter);
    }
}

