/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.metamx.common.guava.Comparators;
import io.druid.query.Result;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectResultValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.joda.time.DateTime;

public class SelectResultValueBuilder {
    private static final Comparator<EventHolder> comparator = new Comparator<EventHolder>(){

        @Override
        public int compare(EventHolder o1, EventHolder o2) {
            int retVal = Longs.compare((long)o1.getTimestamp().getMillis(), (long)o2.getTimestamp().getMillis());
            if (retVal == 0) {
                retVal = o1.getSegmentId().compareTo(o2.getSegmentId());
            }
            if (retVal == 0) {
                retVal = Integer.compare(o1.getOffset(), o2.getOffset());
            }
            return retVal;
        }
    };
    protected final DateTime timestamp;
    protected final PagingSpec pagingSpec;
    protected final boolean descending;
    protected Set<String> dimensions;
    protected Set<String> metrics;
    protected final Queue<EventHolder> pQueue;
    protected final Map<String, Integer> pagingIdentifiers;

    public SelectResultValueBuilder(DateTime timestamp, PagingSpec pagingSpec, boolean descending) {
        this.timestamp = timestamp;
        this.pagingSpec = pagingSpec;
        this.descending = descending;
        this.dimensions = Sets.newHashSet();
        this.metrics = Sets.newHashSet();
        this.pagingIdentifiers = Maps.newLinkedHashMap();
        this.pQueue = this.instantiatePQueue();
    }

    public void addEntry(EventHolder event) {
        this.pQueue.add(event);
    }

    public void finished(String segmentId, int lastOffset) {
        this.pagingIdentifiers.put(segmentId, lastOffset);
    }

    public void addDimension(String dimension) {
        this.dimensions.add(dimension);
    }

    public void addDimensions(Set<String> dimensions) {
        this.dimensions.addAll(dimensions);
    }

    public void addMetric(String metric) {
        this.metrics.add(metric);
    }

    public void addMetrics(Set<String> metrics) {
        this.metrics.addAll(metrics);
    }

    public Result<SelectResultValue> build() {
        return new Result<SelectResultValue>(this.timestamp, new SelectResultValue(this.pagingIdentifiers, this.dimensions, this.metrics, this.getEventHolders()));
    }

    protected List<EventHolder> getEventHolders() {
        return Lists.newArrayList(this.pQueue);
    }

    protected Queue<EventHolder> instantiatePQueue() {
        return Queues.newArrayDeque();
    }

    public static class MergeBuilder
    extends SelectResultValueBuilder {
        public MergeBuilder(DateTime timestamp, PagingSpec pagingSpec, boolean descending) {
            super(timestamp, pagingSpec, descending);
        }

        @Override
        protected Queue<EventHolder> instantiatePQueue() {
            int threshold = this.pagingSpec.getThreshold();
            return MinMaxPriorityQueue.orderedBy((Comparator)(this.descending ? Comparators.inverse((Comparator)comparator) : comparator)).maximumSize(threshold > 0 ? threshold : Integer.MAX_VALUE).create();
        }

        @Override
        protected List<EventHolder> getEventHolders() {
            ArrayList values = Lists.newArrayListWithCapacity((int)this.pQueue.size());
            while (!this.pQueue.isEmpty()) {
                EventHolder event = (EventHolder)this.pQueue.remove();
                this.pagingIdentifiers.put(event.getSegmentId(), event.getOffset());
                values.add(event);
            }
            return values;
        }
    }
}

