/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import com.google.common.base.Supplier;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ComplexColumn;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.RunLengthColumn;
import io.druid.segment.column.SpatialIndex;

class SimpleColumn
implements Column {
    private final ColumnCapabilities capabilities;
    private final Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn;
    private final Supplier<RunLengthColumn> runLengthColumn;
    private final Supplier<GenericColumn> genericColumn;
    private final Supplier<ComplexColumn> complexColumn;
    private final Supplier<BitmapIndex> bitmapIndex;
    private final Supplier<SpatialIndex> spatialIndex;

    SimpleColumn(ColumnCapabilities capabilities, Supplier<DictionaryEncodedColumn> dictionaryEncodedColumn, Supplier<RunLengthColumn> runLengthColumn, Supplier<GenericColumn> genericColumn, Supplier<ComplexColumn> complexColumn, Supplier<BitmapIndex> bitmapIndex, Supplier<SpatialIndex> spatialIndex) {
        this.capabilities = capabilities;
        this.dictionaryEncodedColumn = dictionaryEncodedColumn;
        this.runLengthColumn = runLengthColumn;
        this.genericColumn = genericColumn;
        this.complexColumn = complexColumn;
        this.bitmapIndex = bitmapIndex;
        this.spatialIndex = spatialIndex;
    }

    @Override
    public ColumnCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public int getLength() {
        try (GenericColumn column = (GenericColumn)this.genericColumn.get();){
            int n = column.length();
            return n;
        }
    }

    @Override
    public DictionaryEncodedColumn getDictionaryEncoding() {
        return this.dictionaryEncodedColumn == null ? null : (DictionaryEncodedColumn)this.dictionaryEncodedColumn.get();
    }

    @Override
    public RunLengthColumn getRunLengthColumn() {
        return this.runLengthColumn == null ? null : (RunLengthColumn)this.runLengthColumn.get();
    }

    @Override
    public GenericColumn getGenericColumn() {
        return this.genericColumn == null ? null : (GenericColumn)this.genericColumn.get();
    }

    @Override
    public ComplexColumn getComplexColumn() {
        return this.complexColumn == null ? null : (ComplexColumn)this.complexColumn.get();
    }

    @Override
    public BitmapIndex getBitmapIndex() {
        return this.bitmapIndex == null ? null : (BitmapIndex)this.bitmapIndex.get();
    }

    @Override
    public SpatialIndex getSpatialIndex() {
        return this.spatialIndex == null ? null : (SpatialIndex)this.spatialIndex.get();
    }
}

