/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.VSizeLongSerde;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class DeltaLongEncodingWriter
implements CompressionFactory.LongEncodingWriter {
    private final long base;
    private VSizeLongSerde.LongSerializer serializer;
    private int bitsPerValue;

    public DeltaLongEncodingWriter(long base, long delta) {
        this.base = base;
        this.bitsPerValue = VSizeLongSerde.getBitsForMax(delta + 1L);
    }

    @Override
    public void setBuffer(ByteBuffer buffer) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, buffer, buffer.position());
    }

    @Override
    public void setOutputStream(OutputStream output) {
        this.serializer = VSizeLongSerde.getSerializer(this.bitsPerValue, output);
    }

    @Override
    public void write(long value) throws IOException {
        this.serializer.write(value - this.base);
    }

    @Override
    public void putMeta(OutputStream metaOut, CompressedObjectStrategy.CompressionStrategy strategy) throws IOException {
        metaOut.write(CompressionFactory.setEncodingFlag(strategy.getId()));
        metaOut.write(CompressionFactory.LongEncodingFormat.DELTA.getId());
        metaOut.write(1);
        metaOut.write(Longs.toByteArray((long)this.base));
        metaOut.write(Ints.toByteArray((int)this.bitsPerValue));
    }

    @Override
    public int getBlockSize(int bytesPerBlock) {
        return VSizeLongSerde.getNumValuesPerBlock(this.bitsPerValue, bytesPerBlock);
    }

    @Override
    public int getNumBytes(int values) {
        return VSizeLongSerde.getSerializedSize(this.bitsPerValue, values);
    }

    @Override
    public void flush() throws IOException {
        if (this.serializer != null) {
            this.serializer.close();
        }
    }
}

