/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.druid.client.CacheUtil;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheConfig;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.CacheStrategy;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.SegmentDescriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class CachingQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(CachingQueryRunner.class);
    private final String segmentIdentifier;
    private final SegmentDescriptor segmentDescriptor;
    private final QueryRunner<T> base;
    private final QueryToolChest toolChest;
    private final Cache cache;
    private final ObjectMapper mapper;
    private final CacheConfig cacheConfig;
    private final ListeningExecutorService backgroundExecutorService;

    public CachingQueryRunner(String segmentIdentifier, SegmentDescriptor segmentDescriptor, ObjectMapper mapper, Cache cache, QueryToolChest toolchest, QueryRunner<T> base, ExecutorService backgroundExecutorService, CacheConfig cacheConfig) {
        this.base = base;
        this.segmentIdentifier = segmentIdentifier;
        this.segmentDescriptor = segmentDescriptor;
        this.toolChest = toolchest;
        this.cache = cache;
        this.mapper = mapper;
        this.backgroundExecutorService = MoreExecutors.listeningDecorator((ExecutorService)backgroundExecutorService);
        this.cacheConfig = cacheConfig;
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        Query query = queryPlus.getQuery();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query);
        boolean populateCache = CacheUtil.populateCacheOnDataNodes(query, strategy, this.cacheConfig);
        boolean useCache = CacheUtil.useCacheOnDataNodes(query, strategy, this.cacheConfig);
        final Cache.NamedKey key = strategy != null && (useCache || populateCache) ? CacheUtil.computeSegmentCacheKey(this.segmentIdentifier, this.segmentDescriptor, strategy.computeCacheKey(query)) : null;
        if (useCache) {
            Function cacheFn = strategy.pullFromCache();
            final byte[] cachedResult = this.cache.get(key);
            if (cachedResult != null) {
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                return Sequences.map((Sequence)new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

                    public Iterator<T> make() {
                        try {
                            if (cachedResult.length == 0) {
                                return Iterators.emptyIterator();
                            }
                            return CachingQueryRunner.this.mapper.readValues(CachingQueryRunner.this.mapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }

                    public void cleanup(Iterator<T> iterFromMake) {
                    }
                }), (Function)cacheFn);
            }
        }
        final List cacheFutures = Collections.synchronizedList(Lists.newLinkedList());
        if (populateCache) {
            final Function cacheFn = strategy.prepareForCache();
            return Sequences.withEffect((Sequence)Sequences.map((Sequence)this.base.run(queryPlus, responseContext), (Function)new Function<T, T>(){

                public T apply(final T input) {
                    final SettableFuture future = SettableFuture.create();
                    cacheFutures.add(future);
                    CachingQueryRunner.this.backgroundExecutorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                future.set(cacheFn.apply(input));
                            }
                            catch (Exception e) {
                                future.setException((Throwable)e);
                            }
                        }
                    });
                    return input;
                }
            }), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        CacheUtil.populate(CachingQueryRunner.this.cache, CachingQueryRunner.this.mapper, key, (Iterable)Futures.allAsList((Iterable)cacheFutures).get());
                    }
                    catch (Exception e) {
                        log.error((Throwable)e, "Error while getting future for cache task", new Object[0]);
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }, (Executor)this.backgroundExecutorService);
        }
        return this.base.run(queryPlus, responseContext);
    }
}

