/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.druid.client.DruidServer;
import io.druid.client.FilteredServerInventoryView;
import io.druid.client.HttpServerInventoryViewConfig;
import io.druid.client.ServerInventoryView;
import io.druid.client.ServerView;
import io.druid.client.SingleServerInventoryView;
import io.druid.concurrent.LifecycleLock;
import io.druid.discovery.DataNodeService;
import io.druid.discovery.DiscoveryDruidNode;
import io.druid.discovery.DruidNodeDiscovery;
import io.druid.discovery.DruidNodeDiscoveryProvider;
import io.druid.guice.annotations.EscalatedGlobal;
import io.druid.guice.annotations.Smile;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.Pair;
import io.druid.java.util.common.RetryUtils;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.ScheduledExecutors;
import io.druid.java.util.common.lifecycle.LifecycleStart;
import io.druid.java.util.common.lifecycle.LifecycleStop;
import io.druid.java.util.emitter.EmittingLogger;
import io.druid.java.util.http.client.HttpClient;
import io.druid.java.util.http.client.Request;
import io.druid.java.util.http.client.io.AppendableByteArrayInputStream;
import io.druid.java.util.http.client.response.ClientResponse;
import io.druid.java.util.http.client.response.HttpResponseHandler;
import io.druid.java.util.http.client.response.InputStreamResponseHandler;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.coordination.SegmentChangeRequestDrop;
import io.druid.server.coordination.SegmentChangeRequestHistory;
import io.druid.server.coordination.SegmentChangeRequestLoad;
import io.druid.server.coordination.SegmentChangeRequestsSnapshot;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.joda.time.Duration;

public class HttpServerInventoryView
implements ServerInventoryView,
FilteredServerInventoryView {
    private final EmittingLogger log = new EmittingLogger(HttpServerInventoryView.class);
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private final ConcurrentMap<ServerView.ServerRemovedCallback, Executor> serverCallbacks = new ConcurrentHashMap<ServerView.ServerRemovedCallback, Executor>();
    private final ConcurrentMap<ServerView.SegmentCallback, Executor> segmentCallbacks = new ConcurrentHashMap<ServerView.SegmentCallback, Executor>();
    private final ConcurrentMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>> segmentPredicates = new ConcurrentHashMap<ServerView.SegmentCallback, Predicate<Pair<DruidServerMetadata, DataSegment>>>();
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter;
    private volatile Predicate<Pair<DruidServerMetadata, DataSegment>> finalPredicate;
    private final ConcurrentHashMap<String, DruidServerHolder> servers = new ConcurrentHashMap();
    private volatile ScheduledExecutorService executor;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingDeque<Runnable>();
    private final HttpClient httpClient;
    private final ObjectMapper smileMapper;
    private final HttpServerInventoryViewConfig config;
    private final CountDownLatch inventoryInitializationLatch = new CountDownLatch(1);

    @Inject
    public HttpServerInventoryView(@Smile ObjectMapper smileMapper, @EscalatedGlobal HttpClient httpClient, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, Predicate<Pair<DruidServerMetadata, DataSegment>> defaultFilter, HttpServerInventoryViewConfig config) {
        this.httpClient = httpClient;
        this.smileMapper = smileMapper;
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.defaultFilter = defaultFilter;
        this.finalPredicate = defaultFilter;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        LifecycleLock lifecycleLock = this.lifecycleLock;
        synchronized (lifecycleLock) {
            if (!this.lifecycleLock.canStart()) {
                throw new ISE("can't start.", new Object[0]);
            }
            this.log.info("Starting HttpServerInventoryView.", new Object[0]);
            try {
                this.executor = ScheduledExecutors.fixed((int)this.config.getNumThreads(), (String)"HttpServerInventoryView-%s");
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!HttpServerInventoryView.this.lifecycleLock.awaitStarted()) {
                            HttpServerInventoryView.this.log.error("WTF! lifecycle not started, segments will not be discovered.", new Object[0]);
                            return;
                        }
                        while (!Thread.interrupted() && HttpServerInventoryView.this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                            try {
                                ((Runnable)HttpServerInventoryView.this.queue.take()).run();
                            }
                            catch (InterruptedException ex) {
                                HttpServerInventoryView.this.log.info("main thread interrupted, served segments list is not synced anymore.", new Object[0]);
                                Thread.currentThread().interrupt();
                            }
                            catch (Throwable th) {
                                HttpServerInventoryView.this.log.makeAlert(th, "main thread ignored error", new Object[0]).emit();
                            }
                        }
                        HttpServerInventoryView.this.log.info("HttpServerInventoryView main thread exited.", new Object[0]);
                    }
                });
                DruidNodeDiscovery druidNodeDiscovery = this.druidNodeDiscoveryProvider.getForService("dataNodeService");
                druidNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){
                    private final AtomicBoolean initialized = new AtomicBoolean(false);

                    @Override
                    public void nodesAdded(List<DiscoveryDruidNode> nodes) {
                        nodes.forEach(node -> HttpServerInventoryView.this.serverAdded(this.toDruidServer((DiscoveryDruidNode)node)));
                        if (!this.initialized.getAndSet(true)) {
                            HttpServerInventoryView.this.queue.add(() -> HttpServerInventoryView.this.serverInventoryInitialized());
                        }
                    }

                    @Override
                    public void nodesRemoved(List<DiscoveryDruidNode> nodes) {
                        nodes.forEach(node -> HttpServerInventoryView.this.serverRemoved(this.toDruidServer((DiscoveryDruidNode)node)));
                    }

                    private DruidServer toDruidServer(DiscoveryDruidNode node) {
                        return new DruidServer(node.getDruidNode().getHostAndPortToUse(), node.getDruidNode().getHostAndPort(), node.getDruidNode().getHostAndTlsPort(), ((DataNodeService)node.getServices().get("dataNodeService")).getMaxSize(), ((DataNodeService)node.getServices().get("dataNodeService")).getType(), ((DataNodeService)node.getServices().get("dataNodeService")).getTier(), ((DataNodeService)node.getServices().get("dataNodeService")).getPriority());
                    }
                });
                this.lifecycleLock.started();
            }
            finally {
                this.lifecycleLock.exitStart();
            }
            this.log.info("Waiting for Server Inventory Initialization...", new Object[0]);
            while (!this.inventoryInitializationLatch.await(1L, TimeUnit.MINUTES)) {
                this.log.info("Still waiting for Server Inventory Initialization...", new Object[0]);
            }
            this.log.info("Started HttpServerInventoryView.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        LifecycleLock lifecycleLock = this.lifecycleLock;
        synchronized (lifecycleLock) {
            if (!this.lifecycleLock.canStop()) {
                throw new ISE("can't stop.", new Object[0]);
            }
            this.log.info("Stopping HttpServerInventoryView.", new Object[0]);
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor = null;
            }
            this.queue.clear();
            this.log.info("Stopped HttpServerInventoryView.", new Object[0]);
        }
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        if (this.lifecycleLock.isStarted()) {
            throw new ISE("Lifecycle has already started.", new Object[0]);
        }
        SingleServerInventoryView.FilteringSegmentCallback filteringSegmentCallback = new SingleServerInventoryView.FilteringSegmentCallback(callback, filter);
        this.segmentCallbacks.put(filteringSegmentCallback, exec);
        this.segmentPredicates.put(filteringSegmentCallback, filter);
        this.finalPredicate = Predicates.or(this.defaultFilter, (Predicate)Predicates.or(this.segmentPredicates.values()));
    }

    @Override
    public void registerServerRemovedCallback(Executor exec, ServerView.ServerRemovedCallback callback) {
        if (this.lifecycleLock.isStarted()) {
            throw new ISE("Lifecycle has already started.", new Object[0]);
        }
        this.serverCallbacks.put(callback, exec);
    }

    @Override
    public void registerSegmentCallback(Executor exec, ServerView.SegmentCallback callback) {
        if (this.lifecycleLock.isStarted()) {
            throw new ISE("Lifecycle has already started.", new Object[0]);
        }
        this.segmentCallbacks.put(callback, exec);
    }

    @Override
    public DruidServer getInventoryValue(String containerKey) {
        DruidServerHolder holder = this.servers.get(containerKey);
        if (holder != null) {
            return holder.druidServer;
        }
        return null;
    }

    @Override
    public Collection<DruidServer> getInventory() {
        return this.servers.values().stream().map(serverHolder -> ((DruidServerHolder)serverHolder).druidServer).collect(Collectors.toList());
    }

    private void runSegmentCallbacks(final Function<ServerView.SegmentCallback, ServerView.CallbackAction> fn) {
        for (final Map.Entry entry : this.segmentCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == fn.apply(entry.getKey())) {
                        HttpServerInventoryView.this.segmentCallbacks.remove(entry.getKey());
                        if (HttpServerInventoryView.this.segmentPredicates.remove(entry.getKey()) != null) {
                            HttpServerInventoryView.this.finalPredicate = Predicates.or((Predicate)HttpServerInventoryView.this.defaultFilter, (Predicate)Predicates.or(HttpServerInventoryView.this.segmentPredicates.values()));
                        }
                    }
                }
            });
        }
    }

    private void runServerCallbacks(final DruidServer server) {
        for (final Map.Entry entry : this.serverCallbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(new Runnable(){

                @Override
                public void run() {
                    if (ServerView.CallbackAction.UNREGISTER == ((ServerView.ServerRemovedCallback)entry.getKey()).serverRemoved(server)) {
                        HttpServerInventoryView.this.serverCallbacks.remove(entry.getKey());
                    }
                }
            });
        }
    }

    private void serverInventoryInitialized() {
        for (DruidServerHolder server : this.servers.values()) {
            server.awaitInitialization();
        }
        this.inventoryInitializationLatch.countDown();
        this.log.info("Calling SegmentCallback.segmentViewInitialized() for all callbacks.", new Object[0]);
        this.runSegmentCallbacks(new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

            public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                return input.segmentViewInitialized();
            }
        });
    }

    private void serverAdded(DruidServer server) {
        DruidServerHolder holder = this.servers.computeIfAbsent(server.getName(), k -> new DruidServerHolder(server));
        if (holder.druidServer == server) {
            holder.updateSegmentsListAsync();
        } else {
            this.log.info("Server[%s] already exists.", new Object[]{server.getName()});
        }
    }

    private void serverRemoved(DruidServer server) {
        DruidServerHolder holder = this.servers.remove(server.getName());
        if (holder != null) {
            this.runServerCallbacks(holder.druidServer);
        } else {
            this.log.info("Server[%s] did not exist. Removal notification ignored.", new Object[]{server.getName()});
        }
    }

    @Override
    public boolean isStarted() {
        return this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isSegmentLoadedByServer(String serverKey, DataSegment segment) {
        DruidServerHolder holder = this.servers.get(serverKey);
        return holder != null && holder.druidServer.getSegment(segment.getIdentifier()) != null;
    }

    private static class BytesAccumulatingResponseHandler
    extends InputStreamResponseHandler {
        private int status;
        private String description;

        private BytesAccumulatingResponseHandler() {
        }

        public ClientResponse<AppendableByteArrayInputStream> handleResponse(HttpResponse response) {
            this.status = response.getStatus().getCode();
            this.description = response.getStatus().getReasonPhrase();
            return ClientResponse.unfinished((Object)super.handleResponse(response).getObj());
        }
    }

    private class DruidServerHolder {
        private final Object lock = new Object();
        private final DruidServer druidServer;
        private volatile SegmentChangeRequestHistory.Counter counter = null;
        private final HostAndPort serverHostAndPort;
        private final long serverHttpTimeout = HttpServerInventoryView.access$1200(HttpServerInventoryView.this).getServerTimeout() + 1000L;
        private final CountDownLatch initializationLatch = new CountDownLatch(1);
        private volatile long unstableStartTime = -1L;
        private volatile int consecutiveFailedAttemptCount = 0;
        private final Runnable addToQueueRunnable;

        DruidServerHolder(DruidServer druidServer) {
            this.druidServer = druidServer;
            this.serverHostAndPort = HostAndPort.fromString((String)druidServer.getHost());
            this.addToQueueRunnable = () -> HttpServerInventoryView.this.queue.add(() -> {
                DruidServerHolder holder = (DruidServerHolder)HttpServerInventoryView.this.servers.get(druidServer.getName());
                if (holder != null) {
                    holder.updateSegmentsListAsync();
                }
            });
        }

        void awaitInitialization() {
            try {
                if (!this.initializationLatch.await(this.serverHttpTimeout, TimeUnit.MILLISECONDS)) {
                    HttpServerInventoryView.this.log.warn("Await initialization timed out for server [%s].", new Object[]{this.druidServer.getName()});
                }
            }
            catch (InterruptedException ex) {
                HttpServerInventoryView.this.log.warn("Await initialization interrupted while waiting on server [%s].", new Object[]{this.druidServer.getName()});
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSegmentsListAsync() {
            try {
                String req = this.counter != null ? StringUtils.format((String)"/druid-internal/v1/segments?counter=%s&hash=%s&timeout=%s", (Object[])new Object[]{this.counter.getCounter(), this.counter.getHash(), HttpServerInventoryView.this.config.getServerTimeout()}) : StringUtils.format((String)"/druid-internal/v1/segments?counter=-1&timeout=%s", (Object[])new Object[]{HttpServerInventoryView.this.config.getServerTimeout()});
                URL url = new URL(this.druidServer.getScheme(), this.serverHostAndPort.getHostText(), this.serverHostAndPort.getPort(), req);
                final BytesAccumulatingResponseHandler responseHandler = new BytesAccumulatingResponseHandler();
                HttpServerInventoryView.this.log.debug("Sending segment list fetch request to [%s] on URL [%s]", new Object[]{this.druidServer.getName(), url});
                ListenableFuture future = HttpServerInventoryView.this.httpClient.go(new Request(HttpMethod.GET, url).addHeader("Accept", "application/x-jackson-smile").addHeader("Content-Type", "application/x-jackson-smile"), (HttpResponseHandler)responseHandler, new Duration(this.serverHttpTimeout));
                HttpServerInventoryView.this.log.debug("Sent segment list fetch request to [%s]", new Object[]{this.druidServer.getName()});
                Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<InputStream>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onSuccess(InputStream stream) {
                        try {
                            if (responseHandler.status == 204) {
                                HttpServerInventoryView.this.log.debug("Received NO CONTENT from [%s]", new Object[]{DruidServerHolder.this.druidServer.getName()});
                                return;
                            }
                            if (responseHandler.status != 200) {
                                this.onFailure(null);
                                return;
                            }
                            HttpServerInventoryView.this.log.debug("Received segment list response from [%s]", new Object[]{DruidServerHolder.this.druidServer.getName()});
                            SegmentChangeRequestsSnapshot delta = (SegmentChangeRequestsSnapshot)HttpServerInventoryView.this.smileMapper.readValue(stream, SegmentChangeRequestsSnapshot.class);
                            HttpServerInventoryView.this.log.debug("Finished reading segment list response from [%s]", new Object[]{DruidServerHolder.this.druidServer.getName()});
                            Object object = DruidServerHolder.this.lock;
                            synchronized (object) {
                                block24: {
                                    if (!delta.isResetCounter()) break block24;
                                    HttpServerInventoryView.this.log.info("Server [%s] requested resetCounter for reason [%s].", new Object[]{DruidServerHolder.this.druidServer.getName(), delta.getResetCause()});
                                    DruidServerHolder.this.counter = null;
                                    return;
                                }
                                if (DruidServerHolder.this.counter == null) {
                                    HashMap toRemove = Maps.newHashMap(DruidServerHolder.this.druidServer.getSegments());
                                    for (DataSegmentChangeRequest request : delta.getRequests()) {
                                        if (request instanceof SegmentChangeRequestLoad) {
                                            DataSegment segment = ((SegmentChangeRequestLoad)request).getSegment();
                                            toRemove.remove(segment.getIdentifier());
                                            DruidServerHolder.this.addSegment(segment);
                                            continue;
                                        }
                                        HttpServerInventoryView.this.log.error("Server[%s] gave a non-load dataSegmentChangeRequest[%s]., Ignored.", new Object[]{DruidServerHolder.this.druidServer.getName(), request});
                                    }
                                    for (DataSegment segmentToRemove : toRemove.values()) {
                                        DruidServerHolder.this.removeSegment(segmentToRemove);
                                    }
                                } else {
                                    for (DataSegmentChangeRequest request : delta.getRequests()) {
                                        if (request instanceof SegmentChangeRequestLoad) {
                                            DruidServerHolder.this.addSegment(((SegmentChangeRequestLoad)request).getSegment());
                                            continue;
                                        }
                                        if (request instanceof SegmentChangeRequestDrop) {
                                            DruidServerHolder.this.removeSegment(((SegmentChangeRequestDrop)request).getSegment());
                                            continue;
                                        }
                                        HttpServerInventoryView.this.log.error("Server[%s] gave a non load/drop dataSegmentChangeRequest[%s], Ignored.", new Object[]{DruidServerHolder.this.druidServer.getName(), request});
                                    }
                                }
                                DruidServerHolder.this.counter = delta.getCounter();
                            }
                            DruidServerHolder.this.initializationLatch.countDown();
                            DruidServerHolder.this.consecutiveFailedAttemptCount = 0;
                        }
                        catch (Exception ex) {
                            String logMsg = StringUtils.nonStrictFormat((String)"Error processing segment list response from server [%s]. Reason [%s]", (Object[])new Object[]{DruidServerHolder.this.druidServer.getName(), ex.getMessage()});
                            if (DruidServerHolder.this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                                HttpServerInventoryView.this.log.error((Throwable)ex, logMsg, new Object[0]);
                            } else {
                                HttpServerInventoryView.this.log.info("Temporary Failure. %s", new Object[]{logMsg});
                                HttpServerInventoryView.this.log.debug((Throwable)ex, logMsg, new Object[0]);
                            }
                        }
                        finally {
                            DruidServerHolder.this.addNextSyncToWorkQueue();
                        }
                    }

                    public void onFailure(Throwable t) {
                        try {
                            String logMsg = StringUtils.nonStrictFormat((String)"failed to fetch segment list from server [%s]. Return code [%s], Reason: [%s]", (Object[])new Object[]{DruidServerHolder.this.druidServer.getName(), responseHandler.status, responseHandler.description});
                            if (DruidServerHolder.this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                                if (t != null) {
                                    HttpServerInventoryView.this.log.error(t, logMsg, new Object[0]);
                                } else {
                                    HttpServerInventoryView.this.log.error(logMsg, new Object[0]);
                                }
                            } else {
                                HttpServerInventoryView.this.log.info("Temporary Failure. %s", new Object[]{logMsg});
                                if (t != null) {
                                    HttpServerInventoryView.this.log.debug(t, logMsg, new Object[0]);
                                } else {
                                    HttpServerInventoryView.this.log.debug(logMsg, new Object[0]);
                                }
                            }
                        }
                        finally {
                            DruidServerHolder.this.addNextSyncToWorkQueue();
                        }
                    }
                }, (Executor)HttpServerInventoryView.this.executor);
            }
            catch (Throwable th) {
                try {
                    String logMsg = StringUtils.nonStrictFormat((String)"Fatal error while fetching segment list from server [%s].", (Object[])new Object[]{this.druidServer.getName()});
                    if (this.incrementFailedAttemptAndCheckUnstabilityTimeout()) {
                        HttpServerInventoryView.this.log.makeAlert(th, logMsg, new Object[0]).emit();
                    } else {
                        HttpServerInventoryView.this.log.info("Temporary Failure. %s", new Object[]{logMsg});
                        HttpServerInventoryView.this.log.debug(th, logMsg, new Object[0]);
                    }
                }
                finally {
                    this.addNextSyncToWorkQueue();
                }
            }
        }

        private void addSegment(final DataSegment segment) {
            if (HttpServerInventoryView.this.finalPredicate.apply((Object)Pair.of((Object)this.druidServer.getMetadata(), (Object)segment))) {
                if (this.druidServer.getSegment(segment.getIdentifier()) == null) {
                    this.druidServer.addDataSegment(segment);
                    HttpServerInventoryView.this.runSegmentCallbacks((Function<ServerView.SegmentCallback, ServerView.CallbackAction>)((Function)new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

                        public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                            return input.segmentAdded(DruidServerHolder.this.druidServer.getMetadata(), segment);
                        }
                    }));
                } else {
                    HttpServerInventoryView.this.log.warn("Not adding or running callbacks for existing segment[%s] on server[%s]", new Object[]{segment.getIdentifier(), this.druidServer.getName()});
                }
            }
        }

        private void removeSegment(final DataSegment segment) {
            if (this.druidServer.getSegment(segment.getIdentifier()) != null) {
                this.druidServer.removeDataSegment(segment.getIdentifier());
                HttpServerInventoryView.this.runSegmentCallbacks((Function<ServerView.SegmentCallback, ServerView.CallbackAction>)((Function)new Function<ServerView.SegmentCallback, ServerView.CallbackAction>(){

                    public ServerView.CallbackAction apply(ServerView.SegmentCallback input) {
                        return input.segmentRemoved(DruidServerHolder.this.druidServer.getMetadata(), segment);
                    }
                }));
            } else {
                HttpServerInventoryView.this.log.warn("Not running cleanup or callbacks for non-existing segment[%s] on server[%s]", new Object[]{segment.getIdentifier(), this.druidServer.getName()});
            }
        }

        private void addNextSyncToWorkQueue() {
            if (this.consecutiveFailedAttemptCount > 0) {
                try {
                    long sleepMillis = RetryUtils.nextRetrySleepMillis((int)this.consecutiveFailedAttemptCount);
                    HttpServerInventoryView.this.log.info("Scheduling next syncup in [%d] millis from server [%s].", new Object[]{sleepMillis, this.druidServer.getName()});
                    HttpServerInventoryView.this.executor.schedule(this.addToQueueRunnable, sleepMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    HttpServerInventoryView.this.log.makeAlert((Throwable)ex, "WTF! Couldn't schedule next sync. Server[%s] is not being synced any more, restarting Druid process on that server might fix the issue.", new Object[]{this.druidServer.getName()}).emit();
                }
            } else {
                this.addToQueueRunnable.run();
            }
        }

        private boolean incrementFailedAttemptAndCheckUnstabilityTimeout() {
            if (this.consecutiveFailedAttemptCount > 0 && System.currentTimeMillis() - this.unstableStartTime > HttpServerInventoryView.this.config.getServerUnstabilityTimeout()) {
                return true;
            }
            if (this.consecutiveFailedAttemptCount++ == 0) {
                this.unstableStartTime = System.currentTimeMillis();
            }
            return false;
        }
    }
}

