/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.google.inject.Inject;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheStats;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.java.util.metrics.AbstractMonitor;

public class CacheMonitor
extends AbstractMonitor {
    volatile Cache cache;
    private volatile CacheStats prevCacheStats = null;

    public CacheMonitor() {
    }

    public CacheMonitor(Cache cache) {
        this.cache = cache;
    }

    @Inject(optional=true)
    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        if (this.cache != null) {
            CacheStats currCacheStats = this.cache.getStats();
            CacheStats deltaCacheStats = currCacheStats.delta(this.prevCacheStats);
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
            this.emitStats(emitter, "query/cache/delta", deltaCacheStats, builder);
            this.emitStats(emitter, "query/cache/total", currCacheStats, builder);
            this.prevCacheStats = currCacheStats;
            this.cache.doMonitor(emitter);
        }
        return true;
    }

    private void emitStats(ServiceEmitter emitter, String metricPrefix, CacheStats cacheStats, ServiceMetricEvent.Builder builder) {
        if (this.cache != null) {
            emitter.emit(builder.build(StringUtils.format((String)"%s/numEntries", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumEntries()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/sizeBytes", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getSizeInBytes()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/hits", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumHits()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/misses", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumMisses()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/evictions", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumEvictions()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/hitRate", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.hitRate()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/averageBytes", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.averageBytes()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/timeouts", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumTimeouts()));
            emitter.emit(builder.build(StringUtils.format((String)"%s/errors", (Object[])new Object[]{metricPrefix}), (Number)cacheStats.getNumErrors()));
        }
    }
}

