/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheStats;
import io.druid.client.cache.HybridCacheConfig;
import io.druid.java.util.common.logger.Logger;
import io.druid.java.util.emitter.service.ServiceEmitter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class HybridCache
implements Cache {
    private static final Logger log = new Logger(HybridCache.class);
    private final HybridCacheConfig config;
    private final Cache level1;
    private final Cache level2;
    private final AtomicLong hitCount = new AtomicLong(0L);
    private final AtomicLong missCount = new AtomicLong(0L);

    public HybridCache(HybridCacheConfig config, Cache level1, Cache level2) {
        this.config = config;
        log.info("Config: %s", new Object[]{config});
        this.level1 = level1;
        this.level2 = level2;
    }

    @Override
    @Nullable
    public byte[] get(Cache.NamedKey key) {
        byte[] res = this.level1.get(key);
        if (res == null && (res = this.getL2(key)) != null) {
            this.level1.put(key, res);
        }
        if (res != null) {
            this.hitCount.incrementAndGet();
            return res;
        }
        this.missCount.incrementAndGet();
        return null;
    }

    @Nullable
    private byte[] getL2(Cache.NamedKey key) {
        if (this.config.getUseL2()) {
            return this.level2.get(key);
        }
        return null;
    }

    @Override
    public void put(Cache.NamedKey key, byte[] value) {
        this.level1.put(key, value);
        if (this.config.getPopulateL2()) {
            this.level2.put(key, value);
        }
    }

    @Override
    public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
        HashSet remaining = Sets.newHashSet(keys);
        HashMap res = this.level1.getBulk(keys);
        this.hitCount.addAndGet(res.size());
        remaining = Sets.difference((Set)remaining, res.keySet());
        if (!remaining.isEmpty()) {
            Map<Cache.NamedKey, byte[]> res2 = this.getBulkL2(remaining);
            for (Map.Entry<Cache.NamedKey, byte[]> entry : res2.entrySet()) {
                this.level1.put(entry.getKey(), entry.getValue());
            }
            int size = res2.size();
            this.hitCount.addAndGet(size);
            this.missCount.addAndGet(remaining.size() - size);
            if (size != 0) {
                res = Maps.newHashMap(res);
                res.putAll(res2);
            }
        }
        return res;
    }

    private Map<Cache.NamedKey, byte[]> getBulkL2(Iterable<Cache.NamedKey> keys) {
        if (this.config.getUseL2()) {
            return this.level2.getBulk(keys);
        }
        return Collections.emptyMap();
    }

    @Override
    public void close(String namespace) {
        this.level1.close(namespace);
        this.level2.close(namespace);
    }

    @Override
    public CacheStats getStats() {
        CacheStats stats1 = this.level1.getStats();
        CacheStats stats2 = this.level2.getStats();
        return new CacheStats(this.hitCount.get(), this.missCount.get(), stats1.getNumEntries() + stats2.getNumEntries(), stats1.getSizeInBytes() + stats2.getSizeInBytes(), stats1.getNumEvictions() + stats2.getNumEvictions(), stats1.getNumTimeouts() + stats2.getNumTimeouts(), stats1.getNumErrors() + stats2.getNumErrors());
    }

    @Override
    public boolean isLocal() {
        return this.level1.isLocal() && this.level2.isLocal();
    }

    @Override
    public void doMonitor(ServiceEmitter emitter) {
        this.level1.doMonitor(emitter);
        this.level2.doMonitor(emitter);
    }
}

