/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.client.indexing.ClientAppendQuery;
import io.druid.client.indexing.ClientConversionQuery;
import io.druid.client.indexing.ClientKillQuery;
import io.druid.client.indexing.IndexingService;
import io.druid.discovery.DruidLeaderClient;
import io.druid.indexer.TaskStatusPlus;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.IAE;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.jackson.JacksonUtils;
import io.druid.java.util.http.client.response.FullResponseHolder;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexingServiceClient {
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public IndexingServiceClient(ObjectMapper jsonMapper, @IndexingService DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    public void mergeSegments(List<DataSegment> segments) {
        Iterator<DataSegment> segmentsIter = segments.iterator();
        if (!segmentsIter.hasNext()) {
            return;
        }
        String dataSource = segmentsIter.next().getDataSource();
        while (segmentsIter.hasNext()) {
            DataSegment next = segmentsIter.next();
            if (dataSource.equals(next.getDataSource())) continue;
            throw new IAE("Cannot merge segments of different dataSources[%s] and [%s]", new Object[]{dataSource, next.getDataSource()});
        }
        this.runQuery(new ClientAppendQuery(dataSource, segments));
    }

    public void killSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientKillQuery(dataSource, interval));
    }

    public void upgradeSegment(DataSegment dataSegment) {
        this.runQuery(new ClientConversionQuery(dataSegment));
    }

    public void upgradeSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientConversionQuery(dataSource, interval));
    }

    public List<TaskStatusPlus> getRunningTasks() {
        return this.getTasks("runningTasks");
    }

    public List<TaskStatusPlus> getPendingTasks() {
        return this.getTasks("pendingTasks");
    }

    public List<TaskStatusPlus> getWaitingTasks() {
        return this.getTasks("waitingTasks");
    }

    private List<TaskStatusPlus> getTasks(String endpointSuffix) {
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/%s", (Object[])new Object[]{endpointSuffix})));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching the status of the last complete task", new Object[0]);
            }
            return (List)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<List<TaskStatusPlus>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public TaskStatusPlus getLastCompleteTask() {
        List<TaskStatusPlus> completeTaskStatuses = this.getTasks("completeTasks?n=1");
        return completeTaskStatuses.isEmpty() ? null : completeTaskStatuses.get(0);
    }

    public int killPendingSegments(String dataSource, DateTime end) {
        String endPoint = StringUtils.format((String)"/druid/indexer/v1/pendingSegments/%s?interval=%s", (Object[])new Object[]{dataSource, new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)end)});
        try {
            FullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.DELETE, endPoint));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while killing pendingSegments of dataSource[%s] created until [%s]", new Object[]{dataSource, end});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(responseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object numDeletedObject = resultMap.get("numDeleted");
            return (Integer)Preconditions.checkNotNull(numDeletedObject, (Object)"numDeletedObject");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void runQuery(Object queryObject) {
        try {
            this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task").setContent("application/json", this.jsonMapper.writeValueAsBytes(queryObject)));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

