/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.discovery;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.druid.curator.announcement.Announcer;
import io.druid.discovery.DiscoveryDruidNode;
import io.druid.discovery.DruidNodeAnnouncer;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.logger.Logger;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.utils.ZKPaths;

public class CuratorDruidNodeAnnouncer
implements DruidNodeAnnouncer {
    private static final Logger log = new Logger(CuratorDruidNodeAnnouncer.class);
    private final Announcer announcer;
    private final ZkPathsConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public CuratorDruidNodeAnnouncer(Announcer announcer, ZkPathsConfig config, @Json ObjectMapper jsonMapper) {
        this.announcer = announcer;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public void announce(DiscoveryDruidNode discoveryDruidNode) {
        try {
            log.info("Announcing [%s].", new Object[]{discoveryDruidNode});
            this.announcer.announce(ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()}), this.jsonMapper.writeValueAsBytes((Object)discoveryDruidNode));
            log.info("Announced [%s].", new Object[]{discoveryDruidNode});
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void unannounce(DiscoveryDruidNode discoveryDruidNode) {
        log.info("Unannouncing [%s].", new Object[]{discoveryDruidNode});
        this.announcer.unannounce(ZKPaths.makePath((String)this.config.getInternalDiscoveryPath(), (String)discoveryDruidNode.getNodeType(), (String[])new String[]{discoveryDruidNode.getDruidNode().getHostAndPortToUse()}));
        log.info("Unannounced [%s].", new Object[]{discoveryDruidNode});
    }
}

