/*
 * Decompiled with CFR 0.152.
 */
package io.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.discovery.DruidService;
import io.druid.server.DruidNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DiscoveryDruidNode {
    private final DruidNode druidNode;
    private final String nodeType;
    private final Map<String, DruidService> services = new HashMap<String, DruidService>();

    @JsonCreator
    public DiscoveryDruidNode(@JsonProperty(value="druidNode") DruidNode druidNode, @JsonProperty(value="nodeType") String nodeType, @JsonProperty(value="services") Map<String, DruidService> services) {
        this.druidNode = druidNode;
        this.nodeType = nodeType;
        if (services != null && !services.isEmpty()) {
            this.services.putAll(services);
        }
    }

    @JsonProperty
    public Map<String, DruidService> getServices() {
        return this.services;
    }

    @JsonProperty
    public String getNodeType() {
        return this.nodeType;
    }

    @JsonProperty
    public DruidNode getDruidNode() {
        return this.druidNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryDruidNode that = (DiscoveryDruidNode)o;
        return Objects.equals(this.druidNode, that.druidNode) && Objects.equals(this.nodeType, that.nodeType) && Objects.equals(this.services, that.services);
    }

    public int hashCode() {
        return Objects.hash(this.druidNode, this.nodeType, this.services);
    }

    public String toString() {
        return "DiscoveryDruidNode{druidNode=" + this.druidNode + ", nodeType='" + this.nodeType + '\'' + ", services=" + this.services + '}';
    }
}

