/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import io.druid.client.cache.CacheConfig;
import io.druid.collections.BlockingPool;
import io.druid.collections.DefaultBlockingPool;
import io.druid.collections.NonBlockingPool;
import io.druid.collections.StupidPool;
import io.druid.common.utils.VMUtils;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.BackgroundCaching;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Merging;
import io.druid.guice.annotations.Processing;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.common.concurrent.ExecutorServiceConfig;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.java.util.common.logger.Logger;
import io.druid.offheap.OffheapBufferGenerator;
import io.druid.query.DruidProcessingConfig;
import io.druid.query.ExecutorServiceMonitor;
import io.druid.query.MetricsEmittingExecutorService;
import io.druid.query.PrioritizedExecutorService;
import io.druid.server.metrics.MetricsModule;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DruidProcessingModule
implements Module {
    private static final Logger log = new Logger(DruidProcessingModule.class);

    public void configure(Binder binder) {
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
        MetricsModule.register(binder, ExecutorServiceMonitor.class);
    }

    @Provides
    @BackgroundCaching
    @LazySingleton
    public ExecutorService getBackgroundExecutorService(CacheConfig cacheConfig) {
        if (cacheConfig.getNumBackgroundThreads() > 0) {
            return Executors.newFixedThreadPool(cacheConfig.getNumBackgroundThreads(), new ThreadFactoryBuilder().setNameFormat("background-cacher-%d").setDaemon(true).setPriority(1).build());
        }
        return MoreExecutors.sameThreadExecutor();
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(DruidProcessingConfig config, ExecutorServiceMonitor executorServiceMonitor, Lifecycle lifecycle) {
        return new MetricsEmittingExecutorService((ListeningExecutorService)PrioritizedExecutorService.create((Lifecycle)lifecycle, (DruidProcessingConfig)config), executorServiceMonitor);
    }

    @Provides
    @LazySingleton
    @Global
    public NonBlockingPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new StupidPool("intermediate processing pool", (Supplier)new OffheapBufferGenerator("intermediate processing", config.intermediateComputeSizeBytes()), config.getNumThreads(), config.poolCacheMaxCount());
    }

    @Provides
    @LazySingleton
    @Merging
    public BlockingPool<ByteBuffer> getMergeBufferPool(DruidProcessingConfig config) {
        this.verifyDirectMemory(config);
        return new DefaultBlockingPool((Supplier)new OffheapBufferGenerator("result merging", config.intermediateComputeSizeBytes()), config.getNumMergeBuffers());
    }

    private void verifyDirectMemory(DruidProcessingConfig config) {
        try {
            long maxDirectMemory = VMUtils.getMaxDirectMemory();
            long memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumMergeBuffers() + config.getNumThreads() + 1);
            if (maxDirectMemory < memoryNeeded) {
                throw new ProvisionException(StringUtils.format((String)"Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize, druid.processing.buffer.sizeBytes, druid.processing.numThreads, or druid.processing.numMergeBuffers: maxDirectMemory[%,d], memoryNeeded[%,d] = druid.processing.buffer.sizeBytes[%,d] * (druid.processing.numMergeBuffers[%,d] + druid.processing.numThreads[%,d] + 1)", (Object[])new Object[]{maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumMergeBuffers(), config.getNumThreads()}));
            }
        }
        catch (UnsupportedOperationException e) {
            log.info("Could not verify that you have enough direct memory, so I hope you do! Error message was: %s", new Object[]{e.getMessage()});
        }
    }
}

