/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.MapBinder;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.guice.Binders;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.PolyBind;
import io.druid.initialization.DruidModule;
import io.druid.segment.loading.DataSegmentFinder;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.loading.LocalDataSegmentFinder;
import io.druid.segment.loading.LocalDataSegmentKiller;
import io.druid.segment.loading.LocalDataSegmentPuller;
import io.druid.segment.loading.LocalDataSegmentPusher;
import io.druid.segment.loading.LocalDataSegmentPusherConfig;
import io.druid.segment.loading.LocalFileTimestampVersionFinder;
import io.druid.segment.loading.LocalLoadSpec;
import io.druid.segment.loading.SegmentLoader;
import io.druid.segment.loading.SegmentLoaderLocalCacheManager;
import java.util.List;

public class LocalDataStorageDruidModule
implements DruidModule {
    public static final String SCHEME = "local";

    public void configure(Binder binder) {
        binder.bind(SegmentLoader.class).to(SegmentLoaderLocalCacheManager.class).in(LazySingleton.class);
        LocalDataStorageDruidModule.bindDeepStorageLocal(binder);
        PolyBind.createChoice((Binder)binder, (String)"druid.storage.type", (Key)Key.get(DataSegmentPusher.class), (Key)Key.get(LocalDataSegmentPusher.class));
        PolyBind.createChoice((Binder)binder, (String)"druid.storage.type", (Key)Key.get(DataSegmentKiller.class), (Key)Key.get(LocalDataSegmentKiller.class));
        PolyBind.createChoice((Binder)binder, (String)"druid.storage.type", (Key)Key.get(DataSegmentFinder.class), null);
    }

    private static void bindDeepStorageLocal(Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, SearchableVersionedDataFinder.class).addBinding((Object)"file").to(LocalFileTimestampVersionFinder.class).in(LazySingleton.class);
        Binders.dataSegmentPullerBinder((Binder)binder).addBinding((Object)SCHEME).to(LocalDataSegmentPuller.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DataSegmentKiller.class)).addBinding((Object)SCHEME).to(LocalDataSegmentKiller.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DataSegmentPusher.class)).addBinding((Object)SCHEME).to(LocalDataSegmentPusher.class).in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(DataSegmentFinder.class)).addBinding((Object)SCHEME).to(LocalDataSegmentFinder.class).in(LazySingleton.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.storage", LocalDataSegmentPusherConfig.class);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new Module(){

            public String getModuleName() {
                return "DruidLocalStorage-" + System.identityHashCode((Object)this);
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{LocalLoadSpec.class});
            }
        });
    }
}

