/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.druid.timeline.DataSegment;
import java.util.Objects;
import java.util.Set;

public class SegmentPublishResult {
    private final Set<DataSegment> segments;
    private final boolean success;

    public static SegmentPublishResult fail() {
        return new SegmentPublishResult((Set<DataSegment>)ImmutableSet.of(), false);
    }

    @JsonCreator
    public SegmentPublishResult(@JsonProperty(value="segments") Set<DataSegment> segments, @JsonProperty(value="success") boolean success) {
        this.segments = (Set)Preconditions.checkNotNull(segments, (Object)"segments");
        this.success = success;
        if (!success) {
            Preconditions.checkArgument((boolean)segments.isEmpty(), (Object)"segments must be empty for unsuccessful publishes");
        }
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPublishResult that = (SegmentPublishResult)o;
        return this.success == that.success && Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.success);
    }

    public String toString() {
        return "SegmentPublishResult{segments=" + this.segments + ", success=" + this.success + '}';
    }
}

