/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.druid.java.util.common.lifecycle.Lifecycle;
import io.druid.metadata.MetadataSegmentManager;
import io.druid.metadata.MetadataSegmentManagerConfig;
import io.druid.metadata.MetadataSegmentManagerProvider;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.metadata.SQLMetadataSegmentManager;

public class SQLMetadataSegmentManagerProvider
implements MetadataSegmentManagerProvider {
    private final ObjectMapper jsonMapper;
    private final Supplier<MetadataSegmentManagerConfig> config;
    private final Supplier<MetadataStorageTablesConfig> storageConfig;
    private final SQLMetadataConnector connector;
    private final Lifecycle lifecycle;

    @Inject
    public SQLMetadataSegmentManagerProvider(ObjectMapper jsonMapper, Supplier<MetadataSegmentManagerConfig> config, Supplier<MetadataStorageTablesConfig> storageConfig, SQLMetadataConnector connector, Lifecycle lifecycle) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.storageConfig = storageConfig;
        this.connector = connector;
        this.lifecycle = lifecycle;
    }

    @Override
    public MetadataSegmentManager get() {
        this.lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                SQLMetadataSegmentManagerProvider.this.connector.createSegmentTable();
            }

            public void stop() {
            }
        });
        return new SQLMetadataSegmentManager(this.jsonMapper, this.config, this.storageConfig, this.connector);
    }
}

