/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.druid.java.util.common.StringUtils;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.lookup.LookupExtractionFn;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.lookup.LookupExtractorFactoryContainer;
import io.druid.query.lookup.LookupReferencesManager;
import io.druid.segment.DimensionSelector;
import io.druid.segment.column.ValueType;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class LookupDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 4;
    @JsonProperty
    private final String dimension;
    @JsonProperty
    private final String outputName;
    @JsonProperty
    private final LookupExtractor lookup;
    @JsonProperty
    private final boolean retainMissingValue;
    @JsonProperty
    private final String replaceMissingValueWith;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final boolean optimize;
    private final LookupReferencesManager lookupReferencesManager;

    @JsonCreator
    public LookupDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="lookup") LookupExtractor lookup, @JsonProperty(value="retainMissingValue") boolean retainMissingValue, @JsonProperty(value="replaceMissingValueWith") String replaceMissingValueWith, @JsonProperty(value="name") String name, @JacksonInject LookupReferencesManager lookupReferencesManager, @JsonProperty(value="optimize") Boolean optimize) {
        this.retainMissingValue = retainMissingValue;
        this.optimize = optimize == null ? true : optimize;
        this.replaceMissingValueWith = Strings.emptyToNull((String)replaceMissingValueWith);
        this.dimension = (String)Preconditions.checkNotNull((Object)dimension, (Object)"dimension can not be Null");
        this.outputName = (String)Preconditions.checkNotNull((Object)outputName, (Object)"outputName can not be Null");
        this.lookupReferencesManager = lookupReferencesManager;
        this.name = name;
        this.lookup = lookup;
        Preconditions.checkArgument((boolean)(Strings.isNullOrEmpty((String)name) ^ lookup == null), (String)"name [%s] and lookup [%s] are mutually exclusive please provide either a name or a lookup", (Object[])new Object[]{name, lookup});
        if (!Strings.isNullOrEmpty((String)name)) {
            Preconditions.checkNotNull((Object)this.lookupReferencesManager, (Object)"The system is not configured to allow for lookups, please read about configuring a lookup manager in the docs");
        }
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    public ValueType getOutputType() {
        return ValueType.STRING;
    }

    @JsonProperty
    @Nullable
    public LookupExtractor getLookup() {
        return this.lookup;
    }

    @JsonProperty
    @Nullable
    public String getName() {
        return this.name;
    }

    public ExtractionFn getExtractionFn() {
        LookupExtractor lookupExtractor = Strings.isNullOrEmpty((String)this.name) ? this.lookup : (LookupExtractor)((LookupExtractorFactoryContainer)Preconditions.checkNotNull((Object)this.lookupReferencesManager.get(this.name), (String)"Lookup [%s] not found", (Object[])new Object[]{this.name})).getLookupExtractorFactory().get();
        return new LookupExtractionFn(lookupExtractor, this.retainMissingValue, this.replaceMissingValueWith, lookupExtractor.isOneToOne(), Boolean.valueOf(this.optimize));
    }

    public DimensionSelector decorate(DimensionSelector selector) {
        return selector;
    }

    public boolean mustDecorate() {
        return false;
    }

    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] dimExtractionFnBytes = Strings.isNullOrEmpty((String)this.name) ? this.getLookup().getCacheKey() : StringUtils.toUtf8((String)this.name);
        byte[] outputNameBytes = StringUtils.toUtf8((String)this.outputName);
        byte[] replaceWithBytes = StringUtils.toUtf8((String)Strings.nullToEmpty((String)this.replaceMissingValueWith));
        return ByteBuffer.allocate(6 + dimensionBytes.length + outputNameBytes.length + dimExtractionFnBytes.length + replaceWithBytes.length).put((byte)4).put(dimensionBytes).put((byte)-1).put(outputNameBytes).put((byte)-1).put(dimExtractionFnBytes).put((byte)-1).put(replaceWithBytes).put((byte)-1).put(this.retainMissingValue ? (byte)1 : 0).array();
    }

    public boolean preservesOrdering() {
        return this.getExtractionFn().preservesOrdering();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupDimensionSpec)) {
            return false;
        }
        LookupDimensionSpec that = (LookupDimensionSpec)o;
        if (this.retainMissingValue != that.retainMissingValue) {
            return false;
        }
        if (this.optimize != that.optimize) {
            return false;
        }
        if (!this.getDimension().equals(that.getDimension())) {
            return false;
        }
        if (!this.getOutputName().equals(that.getOutputName())) {
            return false;
        }
        if (this.getLookup() != null ? !this.getLookup().equals(that.getLookup()) : that.getLookup() != null) {
            return false;
        }
        if (this.replaceMissingValueWith != null ? !this.replaceMissingValueWith.equals(that.replaceMissingValueWith) : that.replaceMissingValueWith != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
    }

    public int hashCode() {
        int result = this.getDimension().hashCode();
        result = 31 * result + this.getOutputName().hashCode();
        result = 31 * result + (this.getLookup() != null ? this.getLookup().hashCode() : 0);
        result = 31 * result + (this.retainMissingValue ? 1 : 0);
        result = 31 * result + (this.replaceMissingValueWith != null ? this.replaceMissingValueWith.hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.optimize ? 1 : 0);
        return result;
    }
}

