/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.inject.Inject;
import io.druid.java.util.common.MapUtils;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.loading.DataSegmentKiller;
import io.druid.segment.loading.LocalDataSegmentPusherConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class LocalDataSegmentKiller
implements DataSegmentKiller {
    private static final Logger log = new Logger(LocalDataSegmentKiller.class);
    private static final String PATH_KEY = "path";
    private final File storageDirectory;

    @Inject
    public LocalDataSegmentKiller(LocalDataSegmentPusherConfig config) {
        this.storageDirectory = config.getStorageDirectory();
    }

    public void kill(DataSegment segment) throws SegmentLoadingException {
        block4: {
            File path = this.getPath(segment);
            log.info("killing segment[%s] mapped to path[%s]", new Object[]{segment.getIdentifier(), path});
            try {
                if (path.getName().endsWith(".zip")) {
                    File intervalDir;
                    File partitionNumDir = path.getParentFile();
                    FileUtils.deleteDirectory((File)partitionNumDir);
                    File versionDir = partitionNumDir.getParentFile();
                    if (versionDir.delete() && (intervalDir = versionDir.getParentFile()).delete()) {
                        File dataSourceDir = intervalDir.getParentFile();
                        dataSourceDir.delete();
                    }
                    break block4;
                }
                throw new SegmentLoadingException("Unknown file type[%s]", new Object[]{path});
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to kill segment", new Object[0]);
            }
        }
    }

    public void killAll() throws IOException {
        log.info("Deleting all segment files from local dir [%s].", new Object[]{this.storageDirectory.getAbsolutePath()});
        FileUtils.deleteDirectory((File)this.storageDirectory);
    }

    private File getPath(DataSegment segment) throws SegmentLoadingException {
        return new File(MapUtils.getString((Map)segment.getLoadSpec(), (String)PATH_KEY));
    }
}

