/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import io.druid.curator.discovery.ServiceAnnouncer;
import io.druid.guice.annotations.RemoteChatHandler;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.logger.Logger;
import io.druid.segment.realtime.firehose.ChatHandler;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ServerConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class ServiceAnnouncingChatHandlerProvider
implements ChatHandlerProvider {
    private static final Logger log = new Logger(ServiceAnnouncingChatHandlerProvider.class);
    private final DruidNode node;
    private final ServiceAnnouncer serviceAnnouncer;
    private final ServerConfig serverConfig;
    private final ConcurrentMap<String, ChatHandler> handlers;
    private final ConcurrentSkipListSet<String> announcements;

    @Inject
    public ServiceAnnouncingChatHandlerProvider(@RemoteChatHandler DruidNode node, ServiceAnnouncer serviceAnnouncer, ServerConfig serverConfig) {
        this.node = node;
        this.serviceAnnouncer = serviceAnnouncer;
        this.serverConfig = serverConfig;
        this.handlers = new ConcurrentHashMap<String, ChatHandler>();
        this.announcements = new ConcurrentSkipListSet();
    }

    @Override
    public void register(String service, ChatHandler handler) {
        this.register(service, handler, true);
    }

    @Override
    public void register(String service, ChatHandler handler, boolean announce) {
        log.info("Registering Eventhandler[%s]", new Object[]{service});
        if (this.handlers.putIfAbsent(service, handler) != null) {
            throw new ISE("handler already registered for service[%s]", new Object[]{service});
        }
        if (announce) {
            try {
                this.serviceAnnouncer.announce(this.makeDruidNode(service));
                if (!this.announcements.add(service)) {
                    throw new ISE("announcements already has an entry for service[%s]", new Object[]{service});
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Failed to register service[%s]", new Object[]{service});
                this.handlers.remove(service, handler);
            }
        }
    }

    @Override
    public void unregister(String service) {
        log.info("Unregistering chat handler[%s]", new Object[]{service});
        ChatHandler handler = (ChatHandler)this.handlers.get(service);
        if (handler == null) {
            log.warn("handler[%s] not currently registered, ignoring.", new Object[]{service});
            return;
        }
        if (this.announcements.contains(service)) {
            try {
                this.serviceAnnouncer.unannounce(this.makeDruidNode(service));
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Failed to unregister service[%s]", new Object[]{service});
            }
            this.announcements.remove(service);
        }
        this.handlers.remove(service, handler);
    }

    @Override
    public Optional<ChatHandler> get(String key) {
        return Optional.fromNullable(this.handlers.get(key));
    }

    private DruidNode makeDruidNode(String key) {
        return new DruidNode(key, this.node.getHost(), this.node.getPlaintextPort(), this.node.getTlsPort(), this.node.isEnablePlaintextPort(), this.node.isEnableTlsPort());
    }
}

