/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.google.inject.Inject;
import io.druid.guice.LazySingleton;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.server.QueryLifecycle;
import io.druid.server.log.RequestLogger;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizerMapper;

@LazySingleton
public class QueryLifecycleFactory {
    private final QueryToolChestWarehouse warehouse;
    private final QuerySegmentWalker texasRanger;
    private final GenericQueryMetricsFactory queryMetricsFactory;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;
    private final AuthorizerMapper authorizerMapper;

    @Inject
    public QueryLifecycleFactory(QueryToolChestWarehouse warehouse, QuerySegmentWalker texasRanger, GenericQueryMetricsFactory queryMetricsFactory, ServiceEmitter emitter, RequestLogger requestLogger, AuthConfig authConfig, AuthorizerMapper authorizerMapper) {
        this.warehouse = warehouse;
        this.texasRanger = texasRanger;
        this.queryMetricsFactory = queryMetricsFactory;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
        this.authorizerMapper = authorizerMapper;
    }

    public QueryLifecycle factorize() {
        return new QueryLifecycle(this.warehouse, this.texasRanger, this.queryMetricsFactory, this.emitter, this.requestLogger, this.authorizerMapper, System.currentTimeMillis(), System.nanoTime());
    }
}

