/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import io.druid.java.util.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.server.initialization.ServerConfig;
import java.util.Map;

public class SetAndVerifyContextQueryRunner
implements QueryRunner {
    private final ServerConfig serverConfig;
    private final QueryRunner baseRunner;

    public SetAndVerifyContextQueryRunner(ServerConfig serverConfig, QueryRunner baseRunner) {
        this.serverConfig = serverConfig;
        this.baseRunner = baseRunner;
    }

    public Sequence run(QueryPlus queryPlus, Map responseContext) {
        return this.baseRunner.run(QueryPlus.wrap((Query)SetAndVerifyContextQueryRunner.withTimeoutAndMaxScatterGatherBytes(queryPlus.getQuery(), this.serverConfig)), responseContext);
    }

    public static <T, QueryType extends Query<T>> QueryType withTimeoutAndMaxScatterGatherBytes(QueryType query, ServerConfig serverConfig) {
        return (QueryType)QueryContexts.verifyMaxQueryTimeout((Query)QueryContexts.withMaxScatterGatherBytes((Query)QueryContexts.withDefaultTimeout(query, (long)Math.min(serverConfig.getDefaultQueryTimeout(), serverConfig.getMaxQueryTimeout())), (long)serverConfig.getMaxScatterGatherBytes()), (long)serverConfig.getMaxQueryTimeout());
    }
}

