/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import io.druid.audit.AuditEntry;
import io.druid.audit.AuditManager;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Json;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.server.audit.SQLAuditManagerConfig;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@ManageLifecycle
public class SQLAuditManager
implements AuditManager {
    private final IDBI dbi;
    private final Supplier<MetadataStorageTablesConfig> dbTables;
    private final ServiceEmitter emitter;
    private final ObjectMapper jsonMapper;
    private final SQLAuditManagerConfig config;

    @Inject
    public SQLAuditManager(SQLMetadataConnector connector, Supplier<MetadataStorageTablesConfig> dbTables, ServiceEmitter emitter, @Json ObjectMapper jsonMapper, SQLAuditManagerConfig config) {
        this.dbi = connector.getDBI();
        this.dbTables = dbTables;
        this.emitter = emitter;
        this.jsonMapper = jsonMapper;
        this.config = config;
    }

    public String getAuditTable() {
        return ((MetadataStorageTablesConfig)this.dbTables.get()).getAuditTable();
    }

    public void doAudit(final AuditEntry auditEntry) {
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                SQLAuditManager.this.doAudit(auditEntry, handle);
                return null;
            }
        });
    }

    public void doAudit(AuditEntry auditEntry, Handle handle) throws IOException {
        this.emitter.emit(new ServiceMetricEvent.Builder().setDimension("key", auditEntry.getKey()).setDimension("type", auditEntry.getType()).setDimension("author", auditEntry.getAuditInfo().getAuthor()).build("config/audit", (Number)1));
        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s ( audit_key, type, author, comment, created_date, payload) VALUES (:audit_key, :type, :author, :comment, :created_date, :payload)", (Object[])new Object[]{this.getAuditTable()})).bind("audit_key", auditEntry.getKey())).bind("type", auditEntry.getType())).bind("author", auditEntry.getAuditInfo().getAuthor())).bind("comment", auditEntry.getAuditInfo().getComment())).bind("created_date", auditEntry.getAuditTime().toString())).bind("payload", this.jsonMapper.writeValueAsBytes((Object)auditEntry))).execute();
    }

    public List<AuditEntry> fetchAuditHistory(final String key, final String type, Interval interval) {
        final Interval theInterval = this.getIntervalOrDefault(interval);
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<AuditEntry>>(){

            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                return ((Query)((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE audit_key = :audit_key and type = :type and created_date between :start_date and :end_date ORDER BY created_date", (Object[])new Object[]{SQLAuditManager.this.getAuditTable()})).bind("audit_key", key)).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map((ResultSetMapper)new ResultSetMapper<AuditEntry>(){

                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return (AuditEntry)SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    private Interval getIntervalOrDefault(Interval interval) {
        Interval theInterval;
        if (interval == null) {
            DateTime now = DateTimes.nowUtc();
            theInterval = new Interval((ReadableInstant)now.minus(this.config.getAuditHistoryMillis()), (ReadableInstant)now);
        } else {
            theInterval = interval;
        }
        return theInterval;
    }

    private int getLimit(int limit) throws IllegalArgumentException {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be greater than zero!");
        }
        return limit;
    }

    public List<AuditEntry> fetchAuditHistory(final String type, Interval interval) {
        final Interval theInterval = this.getIntervalOrDefault(interval);
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<AuditEntry>>(){

            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                return ((Query)((Query)((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE type = :type and created_date between :start_date and :end_date ORDER BY created_date", (Object[])new Object[]{SQLAuditManager.this.getAuditTable()})).bind("type", type)).bind("start_date", theInterval.getStart().toString())).bind("end_date", theInterval.getEnd().toString())).map((ResultSetMapper)new ResultSetMapper<AuditEntry>(){

                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return (AuditEntry)SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }

    public List<AuditEntry> fetchAuditHistory(String key, String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(key, type, limit);
    }

    public List<AuditEntry> fetchAuditHistory(String type, int limit) throws IllegalArgumentException {
        return this.fetchAuditHistoryLastEntries(null, type, limit);
    }

    private List<AuditEntry> fetchAuditHistoryLastEntries(final String key, final String type, int limit) throws IllegalArgumentException {
        final int theLimit = this.getLimit(limit);
        String queryString = StringUtils.format((String)"SELECT payload FROM %s WHERE type = :type", (Object[])new Object[]{this.getAuditTable()});
        if (key != null) {
            queryString = queryString + " and audit_key = :audit_key";
        }
        final String theQueryString = queryString = queryString + " ORDER BY created_date DESC";
        return (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<AuditEntry>>(){

            public List<AuditEntry> withHandle(Handle handle) throws Exception {
                Query query = handle.createQuery(theQueryString);
                if (key != null) {
                    query.bind("audit_key", key);
                }
                return ((Query)query.bind("type", type)).setMaxRows(theLimit).map((ResultSetMapper)new ResultSetMapper<AuditEntry>(){

                    public AuditEntry map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return (AuditEntry)SQLAuditManager.this.jsonMapper.readValue(r.getBytes("payload"), AuditEntry.class);
                        }
                        catch (IOException e) {
                            throw new SQLException(e);
                        }
                    }
                }).list();
            }
        });
    }
}

