/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.SegmentChangeRequestHistory;
import java.util.List;

public class SegmentChangeRequestsSnapshot {
    private final boolean resetCounter;
    private final String resetCause;
    private final SegmentChangeRequestHistory.Counter counter;
    private final List<DataSegmentChangeRequest> requests;

    @JsonCreator
    public SegmentChangeRequestsSnapshot(@JsonProperty(value="resetCounter") boolean resetCounter, @JsonProperty(value="resetCause") String resetCause, @JsonProperty(value="counter") SegmentChangeRequestHistory.Counter counter, @JsonProperty(value="requests") List<DataSegmentChangeRequest> requests) {
        this.resetCounter = resetCounter;
        this.resetCause = resetCause;
        if (resetCounter) {
            Preconditions.checkNotNull((Object)resetCause, (Object)"NULL resetCause when resetCounter is true.");
        }
        this.counter = counter;
        this.requests = requests;
    }

    public static SegmentChangeRequestsSnapshot success(SegmentChangeRequestHistory.Counter counter, List<DataSegmentChangeRequest> requests) {
        return new SegmentChangeRequestsSnapshot(false, null, counter, requests);
    }

    public static SegmentChangeRequestsSnapshot fail(String resetCause) {
        return new SegmentChangeRequestsSnapshot(true, resetCause, null, null);
    }

    @JsonProperty
    public boolean isResetCounter() {
        return this.resetCounter;
    }

    @JsonProperty
    public String getResetCause() {
        return this.resetCause;
    }

    @JsonProperty
    public SegmentChangeRequestHistory.Counter getCounter() {
        return this.counter;
    }

    @JsonProperty
    public List<DataSegmentChangeRequest> getRequests() {
        return this.requests;
    }

    public String toString() {
        return "SegmentChangeRequestsSnapshot{resetCounter=" + this.resetCounter + ", resetCause='" + this.resetCause + '\'' + ", counter=" + this.counter + ", requests=" + this.requests + '}';
    }
}

