/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordinator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import io.druid.client.ImmutableDruidServer;
import io.druid.server.coordinator.DruidCluster;
import io.druid.server.coordinator.ServerHolder;
import io.druid.timeline.DataSegment;
import java.util.Map;
import java.util.SortedSet;

public class SegmentReplicantLookup {
    private final Table<String, String, Integer> segmentsInCluster;

    public static SegmentReplicantLookup make(DruidCluster cluster) {
        HashBasedTable segmentsInCluster = HashBasedTable.create();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                ImmutableDruidServer server = serverHolder.getServer();
                for (DataSegment segment : server.getSegments().values()) {
                    Integer numReplicants = (Integer)segmentsInCluster.get((Object)segment.getIdentifier(), (Object)server.getTier());
                    if (numReplicants == null) {
                        numReplicants = 0;
                    }
                    numReplicants = numReplicants + 1;
                    segmentsInCluster.put((Object)segment.getIdentifier(), (Object)server.getTier(), (Object)numReplicants);
                }
            }
        }
        return new SegmentReplicantLookup((Table<String, String, Integer>)segmentsInCluster);
    }

    private SegmentReplicantLookup(Table<String, String, Integer> segmentsInCluster) {
        this.segmentsInCluster = segmentsInCluster;
    }

    public Map<String, Integer> getClusterTiers(String segmentId) {
        Map retVal = this.segmentsInCluster.row((Object)segmentId);
        return retVal == null ? Maps.newHashMap() : retVal;
    }

    public int getLoadedReplicants(String segmentId) {
        Map allTiers = this.segmentsInCluster.row((Object)segmentId);
        int retVal = 0;
        for (Integer replicants : allTiers.values()) {
            retVal += replicants.intValue();
        }
        return retVal;
    }

    public int getLoadedReplicants(String segmentId, String tier) {
        Integer retVal = (Integer)this.segmentsInCluster.get((Object)segmentId, (Object)tier);
        return retVal == null ? 0 : retVal;
    }
}

