/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import io.druid.discovery.DruidNodeDiscoveryProvider;
import io.druid.guice.LazySingleton;
import io.druid.java.util.common.StringUtils;
import io.druid.server.DruidNode;
import io.druid.server.http.security.StateResourceFilter;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/cluster")
@LazySingleton
@ResourceFilters(value={StateResourceFilter.class})
public class ClusterResource {
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;

    @Inject
    public ClusterResource(DruidNodeDiscoveryProvider discoveryProvider) {
        this.druidNodeDiscoveryProvider = discoveryProvider;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") boolean full) {
        Collection<Object> routerNodes;
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        entityBuilder.put((Object)"coordinator", this.getNodes("coordinator", full));
        entityBuilder.put((Object)"overlord", this.getNodes("overlord", full));
        entityBuilder.put((Object)"broker", this.getNodes("broker", full));
        entityBuilder.put((Object)"historical", this.getNodes("historical", full));
        Collection<Object> mmNodes = this.getNodes("middleManager", full);
        if (!mmNodes.isEmpty()) {
            entityBuilder.put((Object)"middleManager", mmNodes);
        }
        if (!(routerNodes = this.getNodes("router", full)).isEmpty()) {
            entityBuilder.put((Object)"router", routerNodes);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)entityBuilder.build()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{nodeType}")
    public Response getClusterServers(@PathParam(value="nodeType") String nodeType, @QueryParam(value="full") boolean full) {
        if (nodeType == null || !DruidNodeDiscoveryProvider.ALL_NODE_TYPES.contains(nodeType)) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).entity((Object)StringUtils.format((String)"Invalid nodeType [%s]. Valid node types are %s .", (Object[])new Object[]{nodeType, DruidNodeDiscoveryProvider.ALL_NODE_TYPES})).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(this.getNodes(nodeType, full)).build();
    }

    private Collection<Object> getNodes(String nodeType, boolean full) {
        Collection<Object> discoveryDruidNodes = this.druidNodeDiscoveryProvider.getForNodeType(nodeType).getAllNodes();
        if (full) {
            return discoveryDruidNodes;
        }
        return Collections2.transform(discoveryDruidNodes, discoveryDruidNode -> Node.from(discoveryDruidNode.getDruidNode()));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Node {
        private final String host;
        private final String service;
        private final Integer plaintextPort;
        private final Integer tlsPort;

        @JsonCreator
        public Node(String host, String service, Integer plaintextPort, Integer tlsPort) {
            this.host = host;
            this.service = service;
            this.plaintextPort = plaintextPort;
            this.tlsPort = tlsPort;
        }

        @JsonProperty
        public String getHost() {
            return this.host;
        }

        @JsonProperty
        public String getService() {
            return this.service;
        }

        @JsonProperty
        public Integer getPlaintextPort() {
            return this.plaintextPort;
        }

        @JsonProperty
        public Integer getTlsPort() {
            return this.tlsPort;
        }

        public static Node from(DruidNode druidNode) {
            return new Node(druidNode.getHost(), druidNode.getServiceName(), druidNode.getPlaintextPort() > 0 ? Integer.valueOf(druidNode.getPlaintextPort()) : null, druidNode.getTlsPort() > 0 ? Integer.valueOf(druidNode.getTlsPort()) : null);
        }
    }
}

