/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.druid.java.util.common.StringUtils;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.http.RedirectInfo;
import java.net.URL;
import java.util.Set;

public class CoordinatorRedirectInfo
implements RedirectInfo {
    private static final Set<String> LOCAL_PATHS = ImmutableSet.of((Object)"/druid/coordinator/v1/leader", (Object)"/druid/coordinator/v1/isLeader");
    private final DruidCoordinator coordinator;

    @Inject
    public CoordinatorRedirectInfo(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public boolean doLocal(String requestURI) {
        return requestURI != null && LOCAL_PATHS.contains(requestURI) || this.coordinator.isLeader();
    }

    @Override
    public URL getRedirectURL(String queryString, String requestURI) {
        try {
            String leader = this.coordinator.getCurrentLeader();
            if (leader == null) {
                return null;
            }
            String location = StringUtils.format((String)"%s%s", (Object[])new Object[]{leader, requestURI});
            if (queryString != null) {
                location = StringUtils.format((String)"%s?%s", (Object[])new Object[]{location, queryString});
            }
            return new URL(location);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

